# -*- coding: utf-8 -*-
from events.common_app.utils import add_model_prefix as add
from events.search.utils import ORMFullTextSearchConstructor


class StaffPersonConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                localizable_params=[
                ],
                not_localizable_params=[
                    add(prefix, to='first_name'),
                    add(prefix, to='last_name'),
                    add(prefix, to='login'),
                ],
                is_full_text_search=True,
            ).get_q_objects_for_text(search_text=search_text)

        return condition


class StaffGroupConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                not_localizable_params=[
                    add(prefix, to='name'),
                    add(prefix, to='url'),
                ],
                is_full_text_search=True,
            ).get_q_objects_for_text(search_text=search_text)

        return condition


class StaffOrganizationConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                not_localizable_params=[
                    add(prefix, to='name'),
                ],
                is_full_text_search=True,
            ).get_q_objects_for_text(search_text=search_text)

        return condition


class StaffOfficeConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                localizable_params=[
                    add(prefix, to='name'),
                ],
                is_full_text_search=True,
            ).get_q_objects_for_text(search_text=search_text)

        return condition
