# -*- coding: utf-8 -*-
import factory

from events.staff.models import (
    StaffGroup,
    StaffPerson,
    StaffOffice,
    StaffOrganization,
)


class StaffGroupFactory(factory.django.DjangoModelFactory):
    staff_id = factory.Sequence(lambda n: n + 100)
    type = 'service'

    class Meta:
        model = StaffGroup


class StaffPersonFactory(factory.django.DjangoModelFactory):
    staff_id = factory.Sequence(lambda n: n + 100)
    yandex_uid = factory.Sequence(lambda n: str(n + 100))
    login = factory.Sequence(lambda n: f'login{n + 100}')

    class Meta:
        model = StaffPerson


class StaffOfficeFactory(factory.django.DjangoModelFactory):
    staff_id = factory.Sequence(lambda n: n + 100)

    class Meta:
        model = StaffOffice


class StaffOrganizationFactory(factory.django.DjangoModelFactory):
    staff_id = factory.Sequence(lambda n: n + 100)

    class Meta:
        model = StaffOrganization
