# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from events.common_app.utils import YLockCommandMixin

from events.staff.models import StaffGroup


class MainCommand(BaseCommand):
    help = """Синхронизирует группы со staff-а"""

    def handle(self, *args, **options):
        StaffGroup.objects.sync_with_source()


class Command(YLockCommandMixin, MainCommand):
    lock_name = 'events.sync_staff_groups'
