# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from events.common_app.utils import YLockCommandMixin

from events.staff.models import StaffOffice


class MainCommand(BaseCommand):
    help = """Синхронизирует офисы со staff-а"""

    def handle(self, *args, **options):
        StaffOffice.objects.sync_with_source()


class Command(YLockCommandMixin, MainCommand):
    lock_name = 'events.sync_staff_offices'
