# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from events.common_app.utils import YLockCommandMixin

from events.staff.models import StaffPerson


class MainCommand(BaseCommand):
    help = """Синхронизирует пользователей со staff-а"""

    def handle(self, *args, **options):
        StaffPerson.objects.sync_with_source()


class Command(YLockCommandMixin, MainCommand):
    lock_name = 'events.sync_staff_persons'
