# Generated by Django 2.2.17 on 2020-12-17 06:26

from django.db import migrations, models
from events.common_app.jsonfield.fields import JSONField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='StaffOffice',
            fields=[
                ('translations', JSONField(blank=True, null=True)),
                ('md5sum', models.CharField(blank=True, max_length=32, null=True)),
                ('staff_id', models.PositiveIntegerField(primary_key=True, serialize=False, verbose_name='ID на стаффе')),
                ('name', models.CharField(db_index=True, max_length=255, null=True)),
                ('address', models.CharField(max_length=255, null=True)),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaffOrganization',
            fields=[
                ('md5sum', models.CharField(blank=True, max_length=32, null=True)),
                ('staff_id', models.PositiveIntegerField(primary_key=True, serialize=False, verbose_name='ID на стаффе')),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaffPerson',
            fields=[
                ('translations', JSONField(blank=True, null=True)),
                ('md5sum', models.CharField(blank=True, max_length=32, null=True)),
                ('staff_id', models.PositiveIntegerField(primary_key=True, serialize=False, verbose_name='ID на стаффе')),
                ('login', models.CharField(db_index=True, max_length=255, unique=True)),
                ('yandex_uid', models.CharField(max_length=255, unique=True)),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
                ('is_dismissed', models.BooleanField(default=False)),
                ('group_id', models.PositiveIntegerField(db_index=True, null=True)),
            ],
            options={
                'index_together': {('login', 'first_name', 'last_name')},
            },
        ),
        migrations.CreateModel(
            name='StaffGroup',
            fields=[
                ('md5sum', models.CharField(blank=True, max_length=32, null=True)),
                ('staff_id', models.PositiveIntegerField(primary_key=True, serialize=False, verbose_name='ID на стаффе')),
                ('name', models.CharField(max_length=255)),
                ('url', models.CharField(max_length=255)),
                ('type', models.CharField(choices=[('department', 'department'), ('service', 'service'), ('servicerole', 'servicerole'), ('wiki', 'wiki')], max_length=255)),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
            ],
            options={
                'index_together': {('name', 'url')},
            },
        ),
    ]
