# -*- coding: utf-8 -*-
# Based on https://github.yandex-team.ru/tools/staff-competentum/blob/master/competentum/report/head_finder.py

def _department_group_heads(login, department_group, role):
    for head in department_group['department']['heads']:
        if head['role'] == role:
            head_login = head['person']['login']
            if head_login != login:
                yield head_login


def _find_heads_in_department_group(login, department_group, role):
    heads = list(_department_group_heads(login, department_group, role))

    if not heads and role == 'chief':
        role = 'general_director'
        heads = list(_department_group_heads(login, department_group, role))

    return heads


def _find_heads_in_ancestors(login, ancestors, role):
    for ancestor in reversed(ancestors):
        result = _find_heads_in_department_group(login, ancestor, role)
        if result:
            return result


def find_heads_by_type(login, department_group, role):
    """
    Ищем близлежащего руководителя/hr-партнера по переданному логину
    учитываем что их может быть несколько

    :param login: str
    :param department_group: dict
    :param head_type: str
    :return: list
    """
    if role == 'chief' and login == 'volozh':  # костыль воложа
        return []

    ancestors = department_group['ancestors']
    if ancestors and login in _department_group_heads(login, department_group, role):
        return _find_heads_in_ancestors(login, ancestors, role)

    return (_find_heads_in_department_group(login, department_group, role) or
            _find_heads_in_ancestors(login, ancestors, role))
