# -*- coding: utf-8 -*-


from rest_framework import serializers

from events.rest_framework_contrib.serializers import InternalModelSerializerV2Mixin
from events.startrek.models import StartrekField


class StartrekFieldSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    values = serializers.JSONField(source='optionValues', required=False, allow_null=True)

    class Meta:
        model = StartrekField
        fields = (
            'id',
            'slug',
            'name',
            'type',
            'values',
        )


class StartrekPrioritySerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    key = serializers.CharField()
    name = serializers.CharField(source='display')


class StartrekPrioritiesSerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    key = serializers.CharField()
    name = serializers.CharField()


class StartrekIssueTypeSerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    key = serializers.CharField()
    name = serializers.CharField(source='display')


class StartrekIssueTypesSerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    key = serializers.CharField()
    name = serializers.CharField()


class StartrekComponentsSerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    name = serializers.CharField()


class StartrekQueueSerializer(InternalModelSerializerV2Mixin, serializers.Serializer):
    id = serializers.IntegerField()
    key = serializers.CharField()
    name = serializers.CharField()
    description = serializers.CharField(default='')
    default_priority = StartrekPrioritySerializer(source='defaultPriority')
    priorities = StartrekPrioritiesSerializer(many=True)
    default_issuetype = StartrekIssueTypeSerializer(source='defaultType')
    issuetypes = StartrekIssueTypesSerializer(many=True)
    components = StartrekComponentsSerializer(many=True)
