# -*- coding: utf-8 -*-

from django.db.models import Q
from events.common_app.utils import add_model_prefix as add
from events.search.utils import ORMFullTextSearchConstructor


class StartrekFieldConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                not_localizable_params=[
                    add(prefix, to='name'),
                ],
                is_full_text_search=True,
            ).get_q_object_for_text(search_text=search_text)

        return condition

    @classmethod
    def filter_by_slugs(cls, slug_list):
        return Q(slug__in=slug_list)

    @classmethod
    def filter_optional_fields(cls):
        return Q(required=False, readonly=False)
