# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand
from events.common_app.utils import YLockCommandMixin

from events.startrek.models import StartrekField


class Command(YLockCommandMixin, BaseCommand):
    help = """Синхронизирует объекты стартрека"""
    lock_name = 'events.sync_startrek'

    def handle(self, *args, **options):
        if not settings.IS_BUSINESS_SITE:
            StartrekField.objects.sync_with_source()
