# -*- coding: utf-8 -*-

from django.db import models

from events.common_app.fields import JSONFieldForSimpleText
from events.startrek.managers import StartrekFieldManager


class StartrekField(models.Model):
    slug = models.CharField(max_length=64, unique=True, db_index=True)
    name = models.CharField(max_length=100, db_index=True)
    order = models.PositiveIntegerField(default=0)
    readonly = models.BooleanField(default=False)
    required = models.BooleanField(default=False)
    type = models.CharField(max_length=100)
    options = models.BooleanField(default=False)
    optionValues = JSONFieldForSimpleText(blank=True, null=True)
    version = models.BigIntegerField()
    url = models.CharField(max_length=100)

    objects = StartrekFieldManager()

    class Meta:
        pass

    class MetaSource:
        unique_field = 'slug'
        source_to_model_fields = {
            'id': 'slug',
            'name': 'name',
            'readonly': 'readonly',
            'order': 'order',
            'version': 'version',
            'schema.required': 'required',
            'schema.type': 'type',
            'self': 'url',
            'options': 'options',
            'optionValues': 'optionValues',
        }

    def __str__(self):
        return 'Поле "%s"' % self.name
