# -*- coding: utf-8 -*-
from rest_framework import serializers
from rest_framework.serializers import ValidationError

from events.common_app.serializers import IdentifierField


class ChangeOwnerSerializer(serializers.Serializer):
    survey_id = IdentifierField()
    uid = serializers.CharField(required=False)
    cloud_uid = serializers.CharField(required=False)
    email = serializers.EmailField(required=False)

    def validate_uid(self, value):
        if not value.isdigit():
            raise ValidationError('Поле должно содержать только цифры')
        return value

    def validate(self, data):
        if 'uid' not in data and 'cloud_uid' not in data and 'email' not in data:
            raise ValidationError('Должно быть указано одно из полей uid, cloud_uid или email')
        return data


class ChangeOrganizationSerializer(serializers.Serializer):
    survey_id = IdentifierField()
    dir_id = serializers.CharField(allow_null=True)

    def validate_dir_id(self, value):
        if value and not value.isdigit():
            raise ValidationError('Поле должно содержать только цифры')
        return value
