# -*- coding: utf-8 -*-
from django.apps import AppConfig
from django.db.models.signals import post_save, pre_save


class SurveymeConfig(AppConfig):
    name = 'events.surveyme'

    def ready(self):
        from events.surveyme.models import Survey, SurveyQuestion, SurveyQuestionChoice
        from events.surveyme.signals import (
            reset_auto_publish_statuses_if_needed,
            create_texts_for_survey,
            set_question_slug,
            set_question_data_source_params,
            set_question_param_widget_by_data_source,
            set_survey_question_choice_default_slug,
            create_survey_tickets,
            create_profile_survey_answer_counter,
        )

        pre_save.connect(reset_auto_publish_statuses_if_needed, Survey)
        post_save.connect(create_texts_for_survey, Survey)
        post_save.connect(create_survey_tickets, Survey)
        post_save.connect(create_profile_survey_answer_counter, Survey)

        post_save.connect(set_question_slug, SurveyQuestion)  # todo: test me
        post_save.connect(set_question_data_source_params, SurveyQuestion)  # todo: test me
        pre_save.connect(set_question_param_widget_by_data_source, SurveyQuestion)

        post_save.connect(set_survey_question_choice_default_slug, SurveyQuestionChoice)
