# -*- coding: utf-8 -*-
from collections import namedtuple


SurveyMetadata = namedtuple('SurveyMetadata', (
    'survey_id',
    'survey_name',
    'is_deleted',
    'version',
))
QuestionMetadata = namedtuple('QuestionMetadata', (
    'survey_id',
    'question_id',
    'answer_type_slug',
    'question_label',
    'data_source',
    'is_deleted',
    'version'
))
ChoiceMetadata = namedtuple('ChoiceMetadata', (
    'question_id',
    'choice_key',
    'choice_label',
    'is_deleted',
    'version',
))
MatrixTitleMetadata = namedtuple('MatrixTitleMetadata', (
    'question_id',
    'matrixtitle_key',
    'matrixtitle_row',
    'matrixtitle_column',
    'is_deleted',
    'version',
))
AccessMetadata = namedtuple('AccessMetadata', (
    'survey_id',
    'login',
    'is_permitted',
    'version',
))
Answer = namedtuple('ProfileSurveyAnswer', (
    'pk',
    'date_created',
    'source_request',
    'data',
))
AnswerRow = namedtuple('Answer', (
    'survey_id',
    'answer_id',
    'created',
    'created_at',
    'question_id',
    'composite_id',
    'is_data_source',
    'is_iframe',
    'ip',
    'uid',
    'yandexuid',
    'value',
))
