# -*- coding: utf-8 -*-
from events.contrib.pydataclasses import DataClass

QUIZ_CALC_METHOD_RANGE = 'range'
QUIZ_CALC_METHOD_SCORES = 'scores'


class ParamQuizAnswer(DataClass):
    correct = bool
    scores = float
    value = str


class ParamQuiz(DataClass):
    enabled = bool
    required = bool
    answers = [ParamQuizAnswer]


class AnswerQuiz(DataClass):
    scores = float
    total_scores = float
    question_count = int
    title = str
    description = str
    image_path = str


class ValueFile(DataClass):
    path = str
    name = str
    size = int


class ValueChoice(DataClass):
    key = str
    slug = str
    text = str


class ValueMatrixTitle(DataClass):
    row = ValueChoice
    col = ValueChoice


class ValueChoices(DataClass):
    value = [ValueChoice]


class ValueMatrixTitles(DataClass):
    value = [ValueMatrixTitle]


class ValueFiles(DataClass):
    value = [ValueFile]


class ValueDateRange(DataClass):
    begin = str
    end = str


class ValueText(DataClass):
    value = str


class ValueNumber(DataClass):
    value = int


class AnswerType(DataClass):
    id = int
    slug = str


class QuestionOptions(DataClass):
    required = bool
    data_source = str
    multiple = bool
    ordering = str
    data_range = bool
    account_id = str


class AnswerQuestion(DataClass):
    id = int
    slug = str
    answer_type = AnswerType
    options = QuestionOptions
    scores = float
    value = None

    def get_value(self):
        if self.answer_type.slug == 'answer_choices':
            if self.options.data_source == 'survey_question_matrix_choice':
                value = ValueMatrixTitles(self.__origin__)
            else:
                value = ValueChoices(self.__origin__)
        elif self.answer_type.slug == 'answer_files':
            value = ValueFiles(self.__origin__)
        elif self.answer_type.slug == 'answer_date':
            if self.options.date_range:
                value = ValueDateRange(self.__origin__)
            else:
                value = ValueText(self.__origin__)
        elif self.answer_type.slug == 'answer_number':
            value = ValueNumber(self.__origin__)
        else:
            value = ValueText(self.__origin__)
        return value.value


class AnswerSurvey(DataClass):
    id = str
    slug = str


class Answer(DataClass):
    survey = AnswerSurvey
    quiz = AnswerQuiz


class SurveyQuizItem(DataClass):
    title = str
    description = str
    image_id = int

    def get_image_path(self):
        from events.media.models import Image
        if self.image_id is not None:
            try:
                image = Image.objects.get(pk=self.image_id).image
                return image.name
            except Image.DoesNotExist:
                pass


class SurveyQuiz(DataClass):
    show_results = bool
    show_correct = bool
    calc_method = str
    pass_scores = float
    items = [SurveyQuizItem]

    def get_item_by_pass_scores(self, total_scores, scores):
        if scores >= 0 and len(self.items) == 2:
            if scores < self.pass_scores or total_scores == 0:
                return self.items[0]
            elif scores <= total_scores:
                return self.items[1]

    def get_item_by_ranges(self, total_scores, scores):
        if scores >= 0 and len(self.items) > 0:
            range_scores = round(total_scores / len(self.items), 2)
            if total_scores == 0:
                return self.items[0]
            for i, item in enumerate(self.items, start=1):
                if scores < range_scores * i:
                    return item
            if scores == total_scores:
                return item

    def get_item(self, total_scores, scores):
        item = None
        if self.calc_method == QUIZ_CALC_METHOD_SCORES:
            item = self.get_item_by_pass_scores(total_scores, scores)
        elif self.calc_method == QUIZ_CALC_METHOD_RANGE:
            item = self.get_item_by_ranges(total_scores, scores)
        return item or SurveyQuizItem()
