# -*- coding: utf-8 -*-
import factory

from events.accounts.factories import UserFactory
from events.conditions.factories import ContentTypeAttributeFactory
from events.surveyme.models import (
    Survey,
    SurveyQuestion,
    ProfileSurveyAnswer,
    SurveyQuestionChoice,
    AnswerExportYtStatus,
    AnswerType,
    SurveyQuestionShowConditionNode,
    SurveyQuestionShowConditionNodeItem,
    SurveyGroup,
    SurveyStateConditionNode,
    SurveyStateConditionItem,
    SurveyStyleTemplate,
    ProfileSurveyAnswerStateConditionResult,
    SurveySubmitConditionNodeItem,
    SurveySubmitConditionNode,
    SurveyTicket,
    SurveyQuestionMatrixTitle,
    SurveyTemplate,
)


class SurveyGroupFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyGroup


class SurveyFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = Survey

    user = factory.SubFactory(UserFactory)
    name = factory.Sequence(lambda n: 'Survey {n}'.format(n=n))
    is_allow_multiple_answers = False


class AnswerExportYtStatusFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = AnswerExportYtStatus


class OverrideFieldsMixin:
    @classmethod
    def _create(cls, target_class, *args, **kwargs):
        # нужно чтобы перехватить настройку модели auto_now
        override_fields = None
        if hasattr(cls, '_Override'):
            override_fields = getattr(cls._Override, 'fields', None)
        if override_fields:
            fields = {}
            for field_name in override_fields or []:
                field = kwargs.pop(field_name, None)
                if field is not None:
                    fields[field_name] = field
            obj = super()._create(target_class, *args, **kwargs)
            if fields:
                for field_name, field in fields.items():
                    setattr(obj, field_name, field)
                obj.save(update_fields=fields.keys())
        else:
            obj = super()._create(target_class, *args, **kwargs)
        return obj


class ProfileSurveyAnswerFactory(OverrideFieldsMixin, factory.django.DjangoModelFactory):
    class Meta:
        model = ProfileSurveyAnswer

    class _Override:
        fields = (
            'date_created',
            'date_updated',
        )

    survey = factory.SubFactory(SurveyFactory)
    user = factory.LazyAttribute(lambda i: UserFactory(uid=None))


class SurveyTicketFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyTicket

    survey = factory.SubFactory(SurveyFactory)


class SurveyQuestionFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyQuestion

    label = factory.Sequence(lambda n: 'Survey question {n}'.format(n=n))
    survey = factory.SubFactory(SurveyFactory)

    @factory.lazy_attribute
    def answer_type(self):
        return AnswerType.objects.all().get(slug='answer_short_text')


class SurveyQuestionChoiceFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyQuestionChoice

    survey_question = factory.SubFactory(SurveyQuestionFactory)


class SurveyQuestionConditionItemFactory(factory.django.DjangoModelFactory):
    class Meta:
        abstract = True

    survey_question = factory.SubFactory(SurveyQuestionFactory)
    survey_question_choice = factory.SubFactory(SurveyQuestionChoiceFactory)


class SurveyQuestionShowConditionNodeFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyQuestionShowConditionNode

    survey_question = factory.SubFactory(SurveyQuestionFactory)


class SurveyQuestionShowConditionNodeItemFactory(SurveyQuestionConditionItemFactory):
    class Meta:
        model = SurveyQuestionShowConditionNodeItem

    survey_question_show_condition_node = factory.SubFactory(SurveyQuestionShowConditionNodeFactory)
    content_type_attribute = factory.SubFactory(ContentTypeAttributeFactory)


# states


class SurveyStateConditionNodeFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyStateConditionNode

    survey = factory.SubFactory(SurveyFactory)


class SurveyStateConditionItemFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyStateConditionItem

    node = factory.SubFactory(SurveyStateConditionNodeFactory)
    survey_question = factory.SubFactory(SurveyQuestionFactory)
    content_type_attribute = factory.SubFactory(ContentTypeAttributeFactory)


class ProfileSurveyAnswerStateConditionResultFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = ProfileSurveyAnswerStateConditionResult

    profile_survey_answer = factory.SubFactory(ProfileSurveyAnswerFactory)
    survey_state_condition_node = factory.SubFactory(SurveyStateConditionNodeFactory)


class SurveySubmitConditionNodeFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveySubmitConditionNode

    survey = factory.SubFactory(SurveyFactory)


class SurveySubmitConditionNodeItemFactory(SurveyQuestionConditionItemFactory):
    class Meta:
        model = SurveySubmitConditionNodeItem

    survey_submit_condition_node = factory.SubFactory(SurveySubmitConditionNodeFactory)


class SurveyQuestionMatrixTitleFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyQuestionMatrixTitle

    survey_question = factory.SubFactory(SurveyQuestionFactory)


class SurveyStyleTemplateFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyStyleTemplate

    name = factory.Sequence(lambda n: u'Style Template {n}'.format(n=n))
    type = 'default'


class SurveyTemplateFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyTemplate

    name = factory.Sequence(lambda n: 'Template {n}'.format(n=n))
    slug = factory.Sequence(lambda n: 'template{n}'.format(n=n))
    position = factory.Sequence(lambda n: n)
