# -*- coding: utf-8 -*-
from django.conf import settings
from django.core.exceptions import ValidationError
from django.utils.translation import ugettext as _

import phonenumbers
from phonenumbers.phonenumberutil import NumberParseException

VALID_FIRST_SYMBOLS = {
    '+',
    '8',
    '495',
    '499',
    '9',
    '00',
}


def validate_phone(value):
    try:
        number = phonenumbers.parse(value, settings.SURVEYME_DEFAULT_PHONE_COUNTRY_CODE)
    except NumberParseException as exc:
        raise ValidationError(exc, code='invalid')
    else:
        if not any(value.startswith(valid_symbol) for valid_symbol in VALID_FIRST_SYMBOLS):
            message = _('Enter phone number in international format (starting with plus sign)')
            raise ValidationError(message)

        if not number.national_number or len(str(number.national_number)) < 5:
            raise ValidationError('', code='invalid')
        if len('%s%s' % (number.country_code, number.national_number)) > 15:
            raise ValidationError('', code='invalid')
