# -*- coding: utf-8 -*-
from django import forms


class DateRangeFieldInput(forms.MultiWidget):
    def __init__(self, attrs=None):
        widgets = (
            forms.DateInput(attrs),
            forms.DateInput(attrs),
        )
        super(DateRangeFieldInput, self).__init__(widgets=widgets, attrs=attrs)

    def decompress(self, value):
        if value:
            return value.date_start, value.date_end
        else:
            return [None, None]


class PaymentWidget(forms.TextInput):
    input_type = 'text'
