# -*- coding: utf-8 -*-
from django import forms

from events.common_app.middleware import get_current_request


class BasePassportField(forms.CharField):
    what_to_get = None

    def prepare_value(self, value):
        if not value:
            return self._get_value_from_passport(value)
        else:
            return value

    def _get_value_from_passport(self, original_value):
        yauser = self._get_yauser()
        if yauser and hasattr(yauser, 'get_profile'):
            return yauser.get_profile().get_fields_from_passport().get(self.what_to_get)
        return original_value

    def _get_yauser(self):
        request = get_current_request()
        if hasattr(request, 'yauser') and request.yauser.is_authenticated():
            return request.yauser
        return None


class PassportNameField(BasePassportField):
    what_to_get = 'param_name'


class PassportSurnameField(BasePassportField):
    what_to_get = 'param_surname'
