# -*- coding: utf-8 -*-
from events.surveyme.factories import SurveyQuestionFactory, ProfileSurveyAnswerFactory


def make_is_has_questions(instance):
    SurveyQuestionFactory(survey=instance)


def make_not_is_has_questions(instance):
    instance.surveyquestion_set.all().delete()


def make_is_ready_for_answer(instance):
    make_is_has_questions(instance)
    instance.is_published_external = True
    instance.save()


def make_not_is_ready_for_answer(instance):
    make_not_is_has_questions(instance)
    instance.is_published_external = False
    instance.save()


def make_is_answer_could_be_edited(instance):
    instance.is_allow_answer_editing = True
    instance.save()


def make_not_is_answer_could_be_edited(instance):
    instance.is_allow_answer_editing = False
    instance.save()


def make_is_already_answered_by_profile(instance, user):
    ProfileSurveyAnswerFactory(survey=instance, user=user)


def make_not_is_already_answered_by_profile(instance, user):
    instance.profilesurveyanswer_set.filter(user=user).delete()


def make_is_type(instance, survey_type):
    instance.type = survey_type
    instance.save()


def make_is_published_external(instance):
    instance.is_published_external = True
    instance.save()


def make_not_is_published_external(instance):
    instance.is_published_external = False
    instance.save()
