# Generated by Django 2.2.17 on 2020-12-17 06:26

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from django.utils.timezone import utc
from events.common_app.fields import (
    AutoIdentifierField,
    JSONFieldForSimpleText,
    SimpleTextField,
)
from events.common_app.jsonfield.fields import JSONField
from events.common_app.utils import generate_code
from events.followme.models import FollowersMixin


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('accounts', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('common_app', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('media', '0001_initial'),
        ('conditions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AnswerType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_allow_choices', models.BooleanField(default=False)),
                ('is_read_only', models.BooleanField(default=False)),
                ('is_allow_widgets', models.BooleanField(default=False)),
                ('is_could_be_used_in_conditions', models.BooleanField(default=False)),
                ('slug', models.SlugField(unique=True)),
                ('name', models.CharField(max_length=255)),
                ('icon', models.CharField(max_length=100)),
                ('admin_preview', models.CharField(choices=[('input', 'Input'), ('textarea', 'Textarea'), ('list', 'List'), ('date', 'Date'), ('gender', 'Gender'), ('statement', 'Statement')], max_length=100)),  # noqa
                ('kind', models.CharField(choices=[('generic', 'Обычный'), ('profile', 'Для профиля')], max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='AnswerTypeSettings',
            fields=[
                ('column_name', models.SlugField(primary_key=True, serialize=False)),
            ],
        ),
        migrations.CreateModel(
            name='ProfileSurveyAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source_request', JSONFieldForSimpleText(blank=True, null=True)),
                ('secret_code', models.CharField(default=generate_code, max_length=255, unique=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, db_index=True, verbose_name='date_of_change')),
                ('data', JSONField(null=True)),
            ],
            options={
                'verbose_name': 'Ответы пользователя на опрос',
                'verbose_name_plural': 'Ответы пользователей на опросы',
                'ordering': ['-date_updated'],
            },
        ),
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('translations', JSONField(blank=True, null=True)),
                ('id', AutoIdentifierField(editable=False, primary_key=True, serialize=False)),
                ('type', models.CharField(default='simple_form', max_length=100)),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='Название')),
                ('need_auth_to_answer', models.BooleanField(default=False, verbose_name='Разрешить ответ на опрос только авторизированным пользователям')),
                ('is_published_external', models.BooleanField(default=False, verbose_name='published_for_external_users')),
                ('is_public', models.BooleanField(default=False, verbose_name='published_for_not_logged_b2b_users')),
                ('is_only_for_iframe', models.BooleanField(default=False, verbose_name='Показывать только в iframe')),
                ('is_allow_answer_editing', models.BooleanField(default=False, verbose_name='Разрешить пользователю редактирование ответа')),
                ('is_allow_multiple_answers', models.BooleanField(default=True, verbose_name='Разрешить делать несколько ответов на форму')),
                ('is_allow_answer_versioning', models.BooleanField(default=False, verbose_name='Показывать пользователю предыдущий ответ в форме')),
                ('is_remove_answer_after_integration', models.BooleanField(default=False, verbose_name='Удалять ответ после срабатывания всех интеграций')),
                ('is_send_user_notification_email_message', models.BooleanField(default=False, verbose_name='Отправить информационное сообщение на почтовый ящик в случае успешного заполнения формы')),
                ('user_notification_email_message_subject', models.CharField(blank=True, max_length=75, verbose_name='Заголовок сообщения об успешном заполнении формы')),
                ('user_notification_email_message_text', models.TextField(blank=True, verbose_name='Текст информационного сообщения')),
                ('user_notification_email_frontend_name', models.CharField(blank=True, max_length=255, null=True)),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('cached_unicode_value', models.CharField(blank=True, max_length=255, null=True)),
                ('is_recent_data_is_sended_to_localize', models.BooleanField(default=False)),
                ('metrika_counter_code', models.CharField(blank=True, max_length=255, verbose_name='номер счетчика метрики')),
                ('save_logs_for_statbox', models.BooleanField(default=False, verbose_name='Сохранять логи для статистики (statbox)')),
                ('captcha_display_mode', models.CharField(choices=[('auto', 'автоматически'), ('always', 'всегда')], default='auto', max_length=100, verbose_name='Режим показа капчи')),
                ('is_spam_detected', models.NullBooleanField(verbose_name='Признак подозрения на спам')),
                ('is_ban_detected', models.NullBooleanField(verbose_name='Признак бана формы')),
                ('slug', models.SlugField(blank=True, null=True, unique=True, verbose_name='slug')),
                ('captcha_type', models.CharField(choices=[('std', 'Стандартная'), ('ocr', 'OCR')], default='std', max_length=100, verbose_name='Тип капчи')),
                ('maximum_answers_count', models.PositiveIntegerField(blank=True, null=True)),
                ('auto_control_publication_status', models.BooleanField(default=False, verbose_name='Управлять статусом публикации автоматически ')),
                ('datetime_auto_open', models.DateTimeField(blank=True, null=True)),
                ('datetime_auto_close', models.DateTimeField(blank=True, null=True)),
                ('validator_url', models.CharField(blank=True, max_length=255, null=True)),
                ('is_deleted', models.BooleanField(db_index=True, default=False, verbose_name='is_survey_deleted')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, null=True, verbose_name='date_of_change')),
                ('date_published', models.DateTimeField(blank=True, null=True, verbose_name='date_published')),
                ('date_unpublished', models.DateTimeField(blank=True, null=True, verbose_name='date_unpublished')),
                ('users_count', models.PositiveIntegerField(blank=True, default=0, null=True)),
                ('groups_count', models.PositiveIntegerField(blank=True, default=0, null=True)),
                ('language', models.CharField(default='ru', max_length=10)),
                ('redirect', JSONField(blank=True, null=True)),
                ('footer', JSONField(blank=True, null=True)),
                ('quiz', JSONField(blank=True, null=True)),
                ('stats', JSONField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Форма',
                'verbose_name_plural': 'Формы',
            },
            bases=(FollowersMixin, models.Model),
        ),
        migrations.CreateModel(
            name='SurveyAgreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('name', models.CharField(max_length=255)),
                ('text', models.TextField()),
                ('is_required', models.BooleanField(default=True)),
                ('slug', models.SlugField(max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'соглашение',
                'verbose_name_plural': 'соглашения',
            },
        ),
        migrations.CreateModel(
            name='SurveyQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('label', models.TextField()),
                ('validator_options', JSONField(blank=True, null=True)),
                ('position', models.PositiveIntegerField(default=0)),
                ('page', models.PositiveIntegerField(default=1)),
                ('initial', JSONFieldForSimpleText(blank=True, null=True)),
                ('is_deleted', models.BooleanField(db_index=True, default=False, verbose_name='is_surveyquestion_deleted')),
                ('param_is_required', models.BooleanField(default=True)),
                ('param_is_allow_multiple_choice', models.BooleanField(default=False)),
                ('param_is_allow_other', models.BooleanField(default=False)),
                ('param_help_text', models.TextField(blank=True)),
                ('param_is_section_header', models.BooleanField(default=False)),
                ('param_max_file_size', models.PositiveSmallIntegerField(default=20, verbose_name='максимальный суммарный размер файлов (мегабайты)')),
                ('param_max_files_count', models.PositiveSmallIntegerField(default=20, verbose_name='максимальное количество файлов')),
                ('param_max', models.IntegerField(blank=True, null=True, verbose_name='максимальное количество')),
                ('param_min', models.IntegerField(blank=True, null=True, verbose_name='минимальное количество')),
                ('param_price', models.PositiveIntegerField(blank=True, null=True, verbose_name='цена билета')),
                ('param_variables', SimpleTextField(blank=True, null=True)),
                ('param_widget', models.CharField(choices=[('list', 'Список'), ('select', 'Селект'), ('matrix', 'Шкала')], default='list', max_length=255)),
                ('param_is_hidden', models.BooleanField(default=False)),
                ('param_is_random_choices_position', models.BooleanField(default=False, verbose_name='Перемешивать варианты ответов')),
                ('param_modify_choices', models.CharField(blank=True, choices=[('natural', 'Не менять порядок'), ('shuffle', 'Перемешать'), ('sort', 'Отсортировать')], default='natural', max_length=64)),  # noqa
                ('param_suggest_choices', models.BooleanField(default=False)),
                ('param_slug', models.SlugField(blank=True, null=True)),
                ('param_is_disabled_init_item', models.BooleanField(default=True, verbose_name='Первый пункт без значения')),
                ('param_data_source', models.CharField(blank=True, default='survey_question_choice', max_length=100, null=True)),
                ('param_data_source_params', JSONFieldForSimpleText(blank=True, null=True)),
                ('param_hint_data_source', models.CharField(blank=True, max_length=100, null=True)),
                ('param_hint_data_source_params', JSONFieldForSimpleText(blank=True, null=True)),
                ('param_date_field_type', models.CharField(default='date', max_length=100)),
                ('param_date_field_min', models.DateField(blank=True, null=True)),
                ('param_date_field_max', models.DateField(blank=True, null=True)),
                ('param_payment', JSONField(blank=True, null=True)),
                ('param_quiz', JSONField(blank=True, null=True)),
                ('answer_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.AnswerType')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_questions', to='surveyme.SurveyQuestion')),
                ('label_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='media.Image')),
            ],
            options={
                'verbose_name': 'Вопрос',
                'verbose_name_plural': 'Вопросы',
                'ordering': ('page', 'position', 'id'),
            },
        ),
        migrations.CreateModel(
            name='SurveyQuestionChoice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('label', models.CharField(max_length=255)),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('slug', models.SlugField(blank=True, null=True, verbose_name='slug')),
                ('is_hidden', models.BooleanField(default=False, verbose_name='скрытое поле')),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
                ('label_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='media.Image')),
                ('survey_question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestion')),
            ],
            options={
                'verbose_name': 'Вариант ответа',
                'verbose_name_plural': 'Варианты ответов',
                'ordering': ('position', 'id'),
                'unique_together': {('survey_question', 'slug')},
            },
        ),
        migrations.CreateModel(
            name='SurveyQuestionHintType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField()),
            ],
        ),
        migrations.CreateModel(
            name='SurveyQuestionShowConditionNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('survey_question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='show_condition_nodes', to='surveyme.SurveyQuestion')),
            ],
            options={
                'ordering': ('position',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SurveySubmitConditionNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submit_condition_nodes', to='surveyme.Survey')),
            ],
            options={
                'ordering': ('position',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AnswerExportYtStatus',
            fields=[
                ('answer', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='export_yt_status', serialize=False, to='surveyme.ProfileSurveyAnswer')),
                ('exported', models.BooleanField(db_index=True, default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ProfileSurveyAnswerCounter',
            fields=[
                ('survey', models.OneToOneField(on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, serialize=False, to='surveyme.Survey')),
                ('answers_count', models.PositiveIntegerField(default=0)),
                ('date_updated', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0, tzinfo=utc))),
            ],
        ),
        migrations.CreateModel(
            name='ValidatorType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(unique=True)),
                ('is_external', models.BooleanField(default=False)),
                ('answer_types', models.ManyToManyField(related_name='validator_types', to='surveyme.AnswerType')),
            ],
        ),
        migrations.CreateModel(
            name='SurveyTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('name', models.CharField(max_length=250)),
                ('description', models.CharField(blank=True, max_length=500, null=True)),
                ('slug', models.SlugField(unique=True)),
                ('data', JSONFieldForSimpleText()),
                ('is_personal', models.BooleanField(default=False)),
                ('position', models.PositiveIntegerField()),
                ('connect_template', models.BooleanField(default=False)),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='media.Image')),
                ('image_admin', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='media.Image')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL, verbose_name='Автор')),
            ],
            options={
                'verbose_name': 'шаблон формы',
                'verbose_name_plural': 'шаблоны форм',
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='SurveySubmitConditionNodeItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('and', 'и'), ('or', 'или')], default='and', max_length=100)),
                ('condition', models.CharField(choices=[('eq', 'равно'), ('neq', 'не равно'), ('lt', 'меньше'), ('gt', 'больше')], default='eq', max_length=100)),
                ('value', models.CharField(blank=True, max_length=100)),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('content_type_attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='conditions.ContentTypeAttribute')),
                ('survey_question', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestion')),
                ('survey_question_choice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestionChoice')),
                ('survey_submit_condition_node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='surveyme.SurveySubmitConditionNode')),
            ],
            options={
                'ordering': ('position',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SurveyStyleTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(choices=[('default', 'по-умолчанию'), ('custom', 'пользовательский')], default='default', max_length=32)),
                ('styles', JSONField(null=True)),
                ('image_form', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='media.Image')),
                ('image_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='media.Image')),
            ],
            options={
                'verbose_name': 'стиль формы',
                'verbose_name_plural': 'стили форм',
            },
        ),
        migrations.CreateModel(
            name='SurveyStateConditionNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('title', models.CharField(max_length=100)),
                ('invite_recommendation', models.CharField(choices=[('invite', 'Пригласить'), ('refuse', 'Отказать')], default='invite', max_length=20)),
                ('limit', models.SmallIntegerField(blank=True, null=True)),
                ('rating', models.SmallIntegerField(blank=True, null=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='surveyme.Survey')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='SurveyStateConditionItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('and', 'и'), ('or', 'или')], default='and', max_length=100)),
                ('condition', models.CharField(choices=[('eq', 'равно'), ('neq', 'не равно'), ('lt', 'меньше'), ('gt', 'больше')], default='eq', max_length=100)),
                ('value', models.CharField(blank=True, max_length=100)),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('title', models.CharField(max_length=100)),
                ('content_type_attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='conditions.ContentTypeAttribute')),
                ('node', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='items', to='surveyme.SurveyStateConditionNode')),
                ('survey_question', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='surveyme.SurveyQuestion')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='SurveyQuestionShowConditionNodeItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('and', 'и'), ('or', 'или')], default='and', max_length=100)),
                ('condition', models.CharField(choices=[('eq', 'равно'), ('neq', 'не равно'), ('lt', 'меньше'), ('gt', 'больше')], default='eq', max_length=100)),
                ('value', models.CharField(blank=True, max_length=100)),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('content_type_attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='conditions.ContentTypeAttribute')),
                ('survey_question', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestion')),
                ('survey_question_choice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestionChoice')),
                ('survey_question_show_condition_node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='surveyme.SurveyQuestionShowConditionNode')),
            ],
            options={
                'verbose_name': 'question show condition item',
                'ordering': ('position',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SurveyQuestionMatrixTitle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('label', models.CharField(max_length=255)),
                ('type', models.CharField(choices=[('row', 'строка'), ('column', 'столбец')], max_length=255)),
                ('position', models.SmallIntegerField(default=1)),
                ('is_deleted', models.BooleanField(db_index=True, default=False)),
                ('survey_question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestion')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='surveyquestion',
            name='param_hint_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestionHintType'),
        ),
        migrations.AddField(
            model_name='surveyquestion',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.Survey'),
        ),
        migrations.AddField(
            model_name='surveyquestion',
            name='validator_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='surveyme.ValidatorType'),
        ),
        migrations.CreateModel(
            name='SurveyGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('metrika_counter_code', models.CharField(blank=True, max_length=255, verbose_name='номер счетчика метрики')),
                ('users_count', models.PositiveIntegerField(default=0)),
                ('groups_count', models.PositiveIntegerField(default=0)),
                ('org', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='accounts.Organization', verbose_name='Организация Я.Коннект')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL, verbose_name='Автор (user)')),
            ],
            options={
                'verbose_name': 'Группа форм',
                'verbose_name_plural': 'Группы форм',
            },
        ),
        migrations.AddField(
            model_name='survey',
            name='agreements',
            field=models.ManyToManyField(blank=True, related_name='surveys', to='surveyme.SurveyAgreement'),
        ),
        migrations.AddField(
            model_name='survey',
            name='content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='survey',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='surveyme.SurveyGroup', verbose_name='Группа'),
        ),
        migrations.AddField(
            model_name='survey',
            name='org',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='accounts.Organization', verbose_name='Организация Я.Коннект'),
        ),
        migrations.AddField(
            model_name='survey',
            name='styles_template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='surveyme.SurveyStyleTemplate'),
        ),
        migrations.AddField(
            model_name='survey',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL, verbose_name='Автор (user)'),
        ),
        migrations.AddField(
            model_name='profilesurveyanswer',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.Survey'),
        ),
        migrations.AddField(
            model_name='profilesurveyanswer',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='answertype',
            name='allow_settings',
            field=models.ManyToManyField(related_name='allow_settings_answertype_set', to='surveyme.AnswerTypeSettings'),
        ),
        migrations.AddField(
            model_name='answertype',
            name='app_types',
            field=models.ManyToManyField(related_name='app_types', to='common_app.AppType'),
        ),
        migrations.AddField(
            model_name='answertype',
            name='required_settings',
            field=models.ManyToManyField(related_name='required_settings_answertype_set', to='surveyme.AnswerTypeSettings'),
        ),
        migrations.CreateModel(
            name='SurveyTicket',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('acquired', models.BooleanField(default=False)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.Survey')),
            ],
            options={
                'index_together': {('survey', 'acquired')},
            },
        ),
        migrations.CreateModel(
            name='SurveyText',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('slug', models.SlugField()),
                ('max_length', models.PositiveSmallIntegerField(null=True)),
                ('null', models.BooleanField(default=False)),
                ('value', models.TextField(blank=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='texts', to='surveyme.Survey')),
            ],
            options={
                'verbose_name': 'сообщение для опроса',
                'unique_together': {('survey', 'slug')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='surveyquestion',
            unique_together={('survey', 'param_slug')},
        ),
        migrations.AlterIndexTogether(
            name='survey',
            index_together={('auto_control_publication_status', 'datetime_auto_open', 'is_published_external'), ('auto_control_publication_status', 'datetime_auto_close', 'is_published_external')},
        ),
        migrations.CreateModel(
            name='ProfileSurveyAnswerStateConditionResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.NullBooleanField()),
                ('profile_survey_answer', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='states', to='surveyme.ProfileSurveyAnswer')),
                ('survey_state_condition_node', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='surveyme.SurveyStateConditionNode')),
            ],
            options={
                'verbose_name': 'state result',
                'verbose_name_plural': 'state results',
                'unique_together': {('profile_survey_answer', 'survey_state_condition_node')},
            },
        ),
    ]
