# Generated by Django 2.2.17 on 2021-01-26 14:48

from django.db import migrations
from django.db.models import Q
from events.common_app.jsonfield.fields import JSONField


def update_extra(apps, schema_editor):
    Survey = apps.get_model('surveyme', 'Survey')
    queryset = (
        Survey.objects.filter(
            Q(quiz__isnull=False)
            | Q(footer__isnull=False)
            | Q(redirect__isnull=False)
            | Q(stats__isnull=False)
        )
    )
    for survey in queryset:
        extra = {}
        if survey.quiz:
            extra['quiz'] = survey.quiz
        if survey.footer:
            extra['footer'] = survey.footer
        if survey.redirect:
            extra['redirect'] = survey.redirect
        if survey.stats:
            extra['stats'] = survey.stats
        survey.extra = extra
        survey.save(update_fields=['extra'])


class Migration(migrations.Migration):

    dependencies = [
        ('surveyme', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='survey',
            name='extra',
            field=JSONField(blank=True, null=True),
        ),
        migrations.RunPython(update_extra, migrations.RunPython.noop),
    ]
