# -*- coding: utf-8 -*-
from django.db import models

from events.conditions.models import ConditionNodeBase, ConditionItemBase


INVITE_RECOMMENDATION_CHOICES = (
    ('invite', 'Пригласить'),
    ('refuse', 'Отказать'),
)


class SurveyStateConditionNode(ConditionNodeBase):
    title = models.CharField(max_length=100)
    invite_recommendation = models.CharField(choices=INVITE_RECOMMENDATION_CHOICES, max_length=20,
                                             default=INVITE_RECOMMENDATION_CHOICES[0][0])
    limit = models.SmallIntegerField(blank=True, null=True)
    rating = models.SmallIntegerField(blank=True, null=True)
    survey = models.ForeignKey('Survey', on_delete=models.DO_NOTHING)

    class Meta:
        app_label = 'surveyme'
        ordering = ('position',)


class SurveyStateConditionItem(ConditionItemBase):
    title = models.CharField(max_length=100)
    node = models.ForeignKey(SurveyStateConditionNode, related_name='items', on_delete=models.DO_NOTHING)
    survey_question = models.ForeignKey('SurveyQuestion', null=True, blank=True, on_delete=models.DO_NOTHING)

    def get_obj(self, profile_survey_answer):
        from events.accounts.models import User
        from events.surveyme.models import ProfileSurveyAnswer

        content_type = self.content_type_attribute.content_type
        model_class = content_type.model_class()
        if model_class == User:
            return profile_survey_answer.user
        elif model_class == ProfileSurveyAnswer:
            return profile_survey_answer

    class Meta:
        app_label = 'surveyme'
        ordering = ('position',)


class ProfileSurveyAnswerStateConditionResult(models.Model):
    profile_survey_answer = models.ForeignKey('ProfileSurveyAnswer', related_name='states', on_delete=models.DO_NOTHING)
    survey_state_condition_node = models.ForeignKey(SurveyStateConditionNode, on_delete=models.DO_NOTHING)
    value = models.NullBooleanField()

    class Meta:
        app_label = 'surveyme'
        unique_together = (('profile_survey_answer', 'survey_state_condition_node'),)
        verbose_name = 'state result'
        verbose_name_plural = 'state results'

    def is_true(self):
        return self.survey_state_condition_node.is_true(
            profile_survey_answer=self.profile_survey_answer
        )
