# -*- coding: utf-8 -*-
from copy import deepcopy
from events.common_app.utils import lazy_import_from_string


SURVEYME_EXPORT_PER_PAGE = 50
SURVEYME_EXPORT_TASKS = 200

SURVEYME_SURVEY_DEFAULT_TEXTS = {
    'redirect_button': {
        'value': {
            'ru': '',
            'en': '',
        },
        'max_length': 30
    },
    'submit_button': {
        'value': {
            'ru': 'Отправить',
            'en': 'Submit',
            'tr': 'Gönder',
            'uk': 'Надіслати',
        },
        'max_length': 30
    },
    'back_button': {
        'value': {
            'ru': 'Назад',
            'en': 'Back',
        },
        'max_length': 30
    },
    'next_button': {
        'value': {
            'ru': 'Вперед',
            'en': 'Next',
        },
        'max_length': 30
    },
    'save_changes_button': {
        'value': {
            'ru': 'Сохранить изменения',
            'en': 'Save changes',
            'tr': 'Değişiklikleri kaydet',
            'uk': 'Зберегти зміни',
        },
        'max_length': 30
    },
    'invitation_to_submit': {
        'value': {
            'ru': 'Ответить на опрос',
            'en': 'Answer survey',
            'tr': 'Ankete katıl',
            'uk': 'Відповісти на опитування',
        },
        'max_length': 30
    },
    'invitation_to_change': {
        'value': {
            'ru': 'Изменить ответ на опрос',
            'en': 'Change survey answer',
            'tr': 'Yanıtı değiştir',
            'uk': 'Змінити відповідь на опитування',
        },
        'max_length': 30
    },
    'successful_submission_title': {
        'value': {
            'ru': 'Спасибо!',
            'en': 'Thanks for the response to a survey',
            'tr': 'Ankete katıldığınız için teşekkür ederiz',
            'uk': 'Дякуємо за відповідь на опитування',
        },
        'max_length': 90
    },
    'successful_submission': {
        'value': {
            'ru': 'Ваше сообщение отправлено.',
        },
        'max_length': 750
    },
    'successful_change_title': {
        'value': {
            'ru': 'Ваш ответ на опрос был изменен',
            'en': 'Your response to the survey was changed',
            'tr': 'Yanıtınız değiştirildi',
            'uk': 'Вашу відповідь на опитування було змінено',
        },
        'max_length': 90
    },
    'successful_change': {
        'null': True,
        'max_length': 750
    }
}

SURVEYME_REGISTRATION_SURVEY_DEFAULT_TEXTS = deepcopy(SURVEYME_SURVEY_DEFAULT_TEXTS)
SURVEYME_REGISTRATION_SURVEY_DEFAULT_TEXTS.update({
    'submit_button': {
        'value': {
            'ru': 'Зарегистрироваться',
            'en': 'Register',
            'tr': 'Kaydol',
            'uk': 'Зареєструватися',
        },
        'max_length': 30
    },
    'invitation_to_submit': {
        'value': {
            'ru': 'Регистрация',
            'en': 'Registration',
            'tr': 'Kayıt',
            'uk': 'Реєстрація',
        },
        'max_length': 30
    },
    'invitation_to_change': {
        'value': {
            'ru': 'Изменить регистрацию',
            'en': 'Change registration',
            'tr': 'Kaydı değiştir',
            'uk': 'Змінити реєстрацію',
        },
        'max_length': 30
    },
    'successful_submission_title': {
        'value': {
            'ru': 'Спасибо за регистрацию',
            'en': 'Thank you for registration',
            'tr': 'Kayıt için teşekkür ederiz',
            'uk': 'Дякуємо за реєстрацію',
        },
        'max_length': 90
    },
    'successful_change_title': {
        'value': {
            'ru': 'Регистрация изменена',
            'en': 'Registration has been changed',
            'tr': 'Kayıt değiştirildi',
            'uk': 'Реєстрацію змінено',
        },
        'max_length': 90
    },
    'access_code_text': {
        'value': {
            'ru': (
                'Внимание! Чтобы ваши личные данные не стали известны третьим лицам, '
                'не передавайте ссылку на эту форму кому-либо и не публикуйте её в открытых источниках. '
                'Заполнить форму можно только один раз. После отправки формы ссылка из письма станет недействительна.'
            ),
            'en': '',
            'tr': (
                'Dikkat! Kişisel bilgilerinizin üçüncü şahısların eline geçmemesi için '
                'bu formun bağlantısını kimseye vermeyin ve açık kaynaklarda yayınlamayın. '
                'Form sadece bir kere doldurulabilir. Form gönderildikten sonra e-postadaki bağlantı geçersiz olacaktır.'
            ),
            'uk': (
                'Увага! Щоб ваші особисті дані не стали відомі третім особам, '
                'не передавайте посилання на цю форму кому-небудь і не публікуйте її у відкритих джерелах. '
                'Заповнити форму можна лише один раз. Після надсилання форми посилання з листа стане недійсним.'
            ),
        },
        'max_length': 600,
    }
})

SURVEYME_FEEDBACK_SURVEY_DEFAULT_TEXTS = deepcopy(SURVEYME_SURVEY_DEFAULT_TEXTS)
SURVEYME_FEEDBACK_SURVEY_DEFAULT_TEXTS.update({
    'submit_button': {
        'value': {
            'ru': 'Отправить отзыв',
            'en': 'Send feedback',
            'tr': 'Yorum gönder',
            'uk': 'Надіслати відгук',
        },
        'max_length': 30
    },
    'invitation_to_submit': {
        'value': {
            'ru': 'Написать отзыв',
            'en': 'Give a feedback',
            'tr': 'Yorum yaz',
            'uk': 'Написати відгук',
        },
        'max_length': 30
    },
    'invitation_to_change': {
        'value': {
            'ru': 'Изменить отзыв',
            'en': 'Change feedback',
            'tr': 'Yorumu değiştir',
            'uk': 'Змінити відгук',
        },
        'max_length': 30
    },
    'successful_submission_title': {
        'value': {
            'ru': 'Спасибо за отзыв',
            'en': 'Thanks for the feedback',
            'tr': 'Yorumunuz için teşekkür ederiz',
            'uk': 'Дякуємо за відгук',
        },
        'max_length': 90
    },
    'successful_change_title': {
        'value': {
            'ru': 'Отзыв был изменен',
            'en': 'Feedback has been changed',
            'tr': 'Yorum değiştirildi',
            'uk': 'Відгук було змінено',
        },
        'max_length': 90
    }
})

SURVEYME_SURVEY_DEFAULT_TEXTS_FOR_TRUST = {
    'payment_page_title': {
        'value': {
            'ru': 'Покупка билета',
            'en': '',
            'tr': 'Bilet satın alma',
            'uk': 'Купівля квитка',
        },
        'max_length': 255
    },
    'successful_payment': {
        'value': {
            'ru': 'Оплата завершена. Спасибо.',
            'en': '',
            'tr': 'Ödeme başarıyla tamamlandı. Teşekkürler',
            'uk': 'Оплату завершено. Дякуємо',
        },
        'max_length': 255
    }
}

SURVEYME_SURVEY_DEFAULT_TEXTS_BY_SURVEY_TYPE = {
    'registration': SURVEYME_REGISTRATION_SURVEY_DEFAULT_TEXTS,
    'feedback': SURVEYME_FEEDBACK_SURVEY_DEFAULT_TEXTS,
}


SURVEYME_SHOW_UNPUBLISHED_FORMS_ON_INTERNAL_SITE = True  # TECH-3079
SURVEYME_DEFAULT_PHONE_COUNTRY_CODE = 'RU'

SURVEYME_VALIDATORS = {
    'decimal': lazy_import_from_string('events.surveyme.validators.DecimalValidator'),
    'inn': lazy_import_from_string('events.surveyme.validators.INNValidator'),
    'russian': lazy_import_from_string('events.surveyme.validators.RussianSymbolsValidator'),
    'regexp': lazy_import_from_string('events.surveyme.validators.RegexpValidator')
}

SURVEYME_REMOVE_ANSWERS_OLDER_THEN = 90  # days

VERSION_GENERATOR_CLASS = 'events.surveyme.versions.SequenceVersionGenerator'
