# -*- coding: utf-8 -*-

from events.common_app.utils import get_query_dict


def get_evaluated_conditions(survey_form):
    survey_form.data = get_form_initial_data(survey_form)
    survey_form.init_fields()
    return survey_form.evaluated_conditions


def get_form_initial_data(survey_form):
    initial = {}
    for name, field in survey_form.fields.items():
        if type(survey_form.initial.get(name, field.initial)) == list:
            initial[name] = survey_form.initial.get(name, field.initial)
        else:
            initial[name] = [survey_form.initial.get(name, field.initial)]
    return get_query_dict(initial)
