# -*- coding: utf-8 -*-
import random

from django.db import connection
from django.conf import settings

from events.common_app.utils import import_from_string


class SequenceVersionGenerator:
    def __init__(self, seq_name):
        self.seq_name = seq_name

    def get_many(self, size):
        c = connection.cursor()
        c.execute('''
            select nextval(%s)
            from generate_series(1, %s)
        ''', (self.seq_name, size))
        for (version,) in c.fetchall():
            yield version

    def get_one(self):
        c = connection.cursor()
        c.execute('''
            select nextval(%s)
        ''', (self.seq_name,))
        (version,) = c.fetchone()
        return version


class RandomVersionGenerator:
    MIN_VERSION = 100000
    MAX_VERSION = 999999

    def __init__(self, *args, **kwargs):
        pass

    def get_many(self, size):
        start = random.randint(self.MIN_VERSION, self.MAX_VERSION)
        for version in range(start, start + size):
            yield version

    def get_one(self):
        return random.randint(self.MIN_VERSION, self.MAX_VERSION)


VersionGenerator = import_from_string(settings.VERSION_GENERATOR_CLASS, 'VERSION_GENERATOR_CLASS')
