# -*- coding: utf-8 -*-

from django.apps import AppConfig
from django.db.models.signals import post_save


class SurveymeIntegrationConfig(AppConfig):
    name = 'events.surveyme_integration'

    def ready(self):
        from events.surveyme_integration.models import (
            IntegrationFileTemplate,
            ServiceSurveyHookSubscription,
        )
        from events.surveyme_integration.signals import (
            set_integration_file_template_slug,
            create_hook_subscription_notification_counter,
        )

        post_save.connect(set_integration_file_template_slug, IntegrationFileTemplate)
        post_save.connect(create_hook_subscription_notification_counter, ServiceSurveyHookSubscription)
