# -*- coding: utf-8 -*-
from events.surveyme_integration.exceptions.base import (
    AuthError,
    IntegrationError,
    TemplateSyntaxError,
    TaskTimeoutError,
    RetriableError,
    ReadError,
    NetworkError,
    ConnectionError,
    PermissionError,
    ServiceError,
    RemoteServiceError,
    HiddenError,

    EMPTY_VALUE_EXCEPTION_MESSAGE,
    NO_SUCH_VARIABLE_MESSAGE,
    UNKNOWN_FIELD_MESSAGE,
)
from events.surveyme_integration.exceptions.email import (
    EmailDataError,
    EmailSenderError,
    EmailRecipientError,
    EmailConnectionError,
    EmailWhiteListError,
    EmailIntegrationError,
    EmailRetriableError,
    EmailSpamError,
    EmailSpamCheckError,
    EmailInternalError,
    EmailValidationError,
    EmailCompaignError,
    EmailMaxSizeExceededError,

    EMAIL_INCORRECT_VARIABLE_TYPE_MESSAGE,
    EMAIL_INCORRECT_QUESTION_TYPE_MESSAGE,
    EMAIL_INCORRECT_EMAIL_MESSAGE,
    EMAIL_INCORRECT_HEADER_NAME,
    EMAIL_INCORRECT_FROM_TITLE,
)
from events.surveyme_integration.exceptions.wiki import (
    WIKI_UNEXPECTED_STATUS_CODE_MESSAGE,
    WIKI_PAGE_DOESNT_EXISTS_MESSAGE,
    WIKI_NO_PERMISSION_MESSAGE,
    WIKI_NOT_VALID_SUPERTAG_MESSAGE,

    WikiIntegrationError,
    WikiPermissionError,
    WikiRetiableError,
    WikiSupertagError,
    WikiContentTypeError,
)
from events.surveyme_integration.exceptions.startrek import (
    STARTREK_INCORRECT_QUEUE_MESSAGE,
    STARTREK_INCORRECT_PARENT_MESSAGE,
    STARTREK_QUEUE_AND_PARENT_EMPTY_MESSAGE,
    STARTREK_QUEUE_NOT_EXIST_MESSAGE,
    STARTREK_PARENT_NOT_EXIST_MESSAGE,
    STARTREK_TYPE_EMPTY_MESSAGE,
    STARTREK_TYPE_NOT_EXIST_MESSAGE,
    STARTREK_PRIORITY_EMPTY_MESSAGE,
    STARTREK_PRIORITY_NOT_EXIST_MESSAGE,
    STARTREK_TITLE_EMPTY_MESSAGE,
    STARTREK_BODY_EMPTY_MESSAGE,
    STARTREK_CHECK_FIELDS_MESSAGE,

    TrackerConfigError,
    TrackerIntegrationError,
    TrackerPermissionError,
    TrackerRetriableError,
    TrackerTaskNotExistError,
    TrackerUserNotExistError,
    TrackerTimeoutError,
)
from events.surveyme_integration.exceptions.utils import (
    reraise,
    get_email_error,
    get_error_class,
    get_general_error,
    get_post_error,
    get_startrek_error,
    get_wiki_error,
)

__all__ = [
    'AuthError',
    'ConnectionError',
    'EMAIL_INCORRECT_EMAIL_MESSAGE',
    'EMAIL_INCORRECT_FROM_TITLE',
    'EMAIL_INCORRECT_HEADER_NAME',
    'EMAIL_INCORRECT_QUESTION_TYPE_MESSAGE',
    'EMAIL_INCORRECT_VARIABLE_TYPE_MESSAGE',
    'EMPTY_VALUE_EXCEPTION_MESSAGE',
    'EmailConnectionError',
    'EmailDataError',
    'EmailIntegrationError',
    'EmailRecipientError',
    'EmailRetriableError',
    'EmailCompaignError',
    'EmailSenderError',
    'EmailInternalError',
    'EmailMaxSizeExceededError',
    'EmailValidationError',
    'EmailSpamCheckError',
    'EmailSpamError',
    'EmailWhiteListError',
    'HiddenError',
    'IntegrationError',
    'NO_SUCH_VARIABLE_MESSAGE',
    'NetworkError',
    'PermissionError',
    'ReadError',
    'RemoteServiceError',
    'RetriableError',
    'STARTREK_BODY_EMPTY_MESSAGE',
    'STARTREK_CHECK_FIELDS_MESSAGE',
    'STARTREK_INCORRECT_PARENT_MESSAGE',
    'STARTREK_INCORRECT_QUEUE_MESSAGE',
    'STARTREK_PARENT_NOT_EXIST_MESSAGE',
    'STARTREK_PRIORITY_EMPTY_MESSAGE',
    'STARTREK_PRIORITY_NOT_EXIST_MESSAGE',
    'STARTREK_QUEUE_AND_PARENT_EMPTY_MESSAGE',
    'STARTREK_QUEUE_NOT_EXIST_MESSAGE',
    'STARTREK_TITLE_EMPTY_MESSAGE',
    'STARTREK_TYPE_EMPTY_MESSAGE',
    'STARTREK_TYPE_NOT_EXIST_MESSAGE',
    'ServiceError',
    'TrackerConfigError',
    'TrackerIntegrationError',
    'TrackerPermissionError',
    'TrackerRetriableError',
    'TrackerTaskNotExistError',
    'TrackerTimeoutError',
    'TrackerUserNotExistError',
    'TaskTimeoutError',
    'TemplateSyntaxError',
    'UNKNOWN_FIELD_MESSAGE',
    'WIKI_NOT_VALID_SUPERTAG_MESSAGE',
    'WIKI_NO_PERMISSION_MESSAGE',
    'WIKI_PAGE_DOESNT_EXISTS_MESSAGE',
    'WIKI_UNEXPECTED_STATUS_CODE_MESSAGE',
    'WikiContentTypeError',
    'WikiIntegrationError',
    'WikiPermissionError',
    'WikiRetiableError',
    'WikiSupertagError',
    'get_email_error',
    'get_error_class',
    'get_general_error',
    'get_post_error',
    'get_startrek_error',
    'get_wiki_error',
    'reraise',
]
