# -*- coding: utf-8 -*-


from django.utils.encoding import force_str
from django.utils.translation import ugettext_lazy as _

EMPTY_VALUE_EXCEPTION_MESSAGE = _('Это поле должно быть заполнено')
NO_SUCH_VARIABLE_MESSAGE = _('Переменной %(var_id)s не существует')
UNKNOWN_FIELD_MESSAGE = _('Неизвестное поле')


class IntegrationError(Exception):
    help = _('Необработанная ошибка')

    def __init__(self, cause=None):
        message = self.help
        if type(self) == IntegrationError and cause is not None:
            cause_message = None
            cause_args = cause.args
            if cause_args:
                cause_message = force_str(cause_args[0])
            message = cause_message or self.help
        super(IntegrationError, self).__init__(message)
        self.cause = cause


class RetriableError(IntegrationError):
    help = _('Ошибка с возможностью перезапуска.')


class ServiceError(RetriableError):
    help = _('Ошибка сервиса.')

    def __init__(self, content, cause=None):
        self.help = ' '.join([force_str(self.help), force_str(content)])
        super(ServiceError, self).__init__(cause)


class RemoteServiceError(ServiceError):
    help = _('Ошибка внешнего сервиса.')


class ConnectionError(RetriableError):
    help = _('Ошибка соединения.')


class ReadError(RetriableError):
    help = _('Ошибка при получении данных от сервиса.')


class NetworkError(RetriableError):
    help = _('Сетевая ошибка.')


class AuthError(RetriableError):
    help = _('Невозможно аутетифицироваться на сервисе.')


class PermissionError(IntegrationError):
    help = _('Недостаточно прав для выполнения операции.')


class TemplateSyntaxError(RetriableError):
    help = _('Ошибка в синтаксисе шаблона.')


class TaskTimeoutError(RetriableError):
    help = _('Превышение времени исполнения задачи.')


class HiddenError(object):
    help = _('Скрытая ошибка, не попадает в логи кулауда')
