# -*- coding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _

from events.surveyme_integration.exceptions.base import (
    ConnectionError,
    HiddenError,
    IntegrationError,
    RetriableError,
)


class EmailIntegrationError(IntegrationError):
    help = _('Ошибка почтовой интеграции.')

    def __init__(self, comment='', cause=None):
        self.help = ' '.join([str(self.help), comment])
        super().__init__(cause)


class EmailRetriableError(RetriableError, EmailIntegrationError):
    help = _('Перезапускаемая ошибка почтовой интеграции.')


class EmailInternalError(EmailRetriableError):
    help = _('Внутренняя ошибка сервиса отправки почты.')


class EmailValidationError(EmailIntegrationError):
    help = ''


class EmailMaxSizeExceededError(EmailIntegrationError):
    help = _('Суммарный объем файлов должен быть меньше 9 МБ.')


class EmailCompaignError(EmailIntegrationError):
    help = _('Ошибка отправки почты, не настроена кампания.')


class EmailWhiteListError(EmailIntegrationError):
    help = _('Получатель сообщения не находится в белом списке.')


class EmailConnectionError(ConnectionError, EmailRetriableError):
    help = _('Ошибка соединения с smtp-сервером.')


class EmailRecipientError(EmailRetriableError):
    help = _('Ошибка в адресе получателя.')


class EmailSenderError(EmailRetriableError):
    help = _('Ошибка в адресе отправителя.')


class EmailDataError(EmailIntegrationError):
    help = _('В сообщении содержатся ошибки, из-за которых почтовый сервер не может его принять.')


class EmailSpamError(HiddenError, EmailIntegrationError):
    help = _('Сообщение определено как спам')


class EmailSpamCheckError(EmailRetriableError):
    help = _('Ошибка в процессе проверки на спам')


EMAIL_INCORRECT_VARIABLE_TYPE_MESSAGE = _('Некорректный тип переменной %(var_id)s')
EMAIL_INCORRECT_QUESTION_TYPE_MESSAGE = _('Ошибка в переменной %(var_id)s: поддерживаются только вопросы типа "Почта"')
EMAIL_INCORRECT_EMAIL_MESSAGE = _('%(email)s: некорректный email')
EMAIL_INCORRECT_HEADER_NAME = _('Некорректное название заголовка: %s')
EMAIL_INCORRECT_FROM_TITLE = _('Имя отправителя может содержать только буквы и цифры')
