# -*- coding: utf-8 -*-
from django.utils.encoding import force_str
from django.utils.translation import ugettext_lazy as _

from events.surveyme_integration.exceptions.base import (
    IntegrationError,
    PermissionError,
    RetriableError,
)


STARTREK_INCORRECT_QUEUE_MESSAGE = _('Поле "Очередь" имеет неправильный формат')
STARTREK_INCORRECT_PARENT_MESSAGE = _('Поле "Сделать подзадачей" имеет неправильный формат')
STARTREK_QUEUE_AND_PARENT_EMPTY_MESSAGE = _('Должно быть заполнено поле "Очередь" или "Сделать подзадачей"')
STARTREK_QUEUE_NOT_EXIST_MESSAGE = _('Очередь "%s" не существует или к ней нет доступа')
STARTREK_PARENT_NOT_EXIST_MESSAGE = _('Тикет "%s" не существует или к нему нет доступа')
STARTREK_TYPE_EMPTY_MESSAGE = _('Не указан тип для задачи')
STARTREK_TYPE_NOT_EXIST_MESSAGE = _('Указан несуществующий тип')
STARTREK_PRIORITY_EMPTY_MESSAGE = _('Не указан приоритет для задачи')
STARTREK_PRIORITY_NOT_EXIST_MESSAGE = _('Указан несуществующий приоритет')
STARTREK_TITLE_EMPTY_MESSAGE = _('Не указан заголовок тикета')
STARTREK_BODY_EMPTY_MESSAGE = _('Не указано тело тикета')
STARTREK_CHECK_FIELDS_MESSAGE = _('Проверьте поля: %(fields)s')


class TrackerIntegrationError(IntegrationError):
    help = _('Ошибка интеграции с трекером.')


class TrackerRetriableError(RetriableError, TrackerIntegrationError):
    help = _('Перезапускаемая ошибка с трекером.')


class TrackerPermissionError(PermissionError, TrackerIntegrationError):
    help = _('Нет прав на запись в очередь.')


class TrackerTaskNotExistError(TrackerIntegrationError):
    help = _('Родительский тикет или очередь не существуют.')


class TrackerUserNotExistError(TrackerIntegrationError):
    help = _('Пользователь не существует.')


class TrackerTimeoutError(TrackerRetriableError):
    help = _('Превышен интервал ожидания ответа')


class TrackerConfigError(TrackerIntegrationError):
    help = _('Ошибка в настройках интеграции.')

    def __init__(self, comment, cause=None):
        self.help = ' '.join([force_str(self.help), comment])
        super(TrackerConfigError, self).__init__(cause)
