# -*- coding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _

from events.surveyme_integration.exceptions.base import (
    IntegrationError,
    RetriableError,
    PermissionError,
)

WIKI_PAGE_DOESNT_EXISTS_MESSAGE = _('Указанная вики страница %s не существует или к ней нет доступа у робота форм')
WIKI_NO_PERMISSION_MESSAGE = _('У пользователя %s нет доступа к указанной вики-странице, его следует выдать используя интерфейс вики')
WIKI_NOT_VALID_SUPERTAG_MESSAGE = _('%s не является корректным адресом вики-страницы')
WIKI_UNEXPECTED_STATUS_CODE_MESSAGE = _('Произошла ошибка при работе с вики, попробуйте еще раз, если ошибка повторяется - обратитесь в поддержку')
WIKI_CONTENT_TYPE_ERROR = _('Некорректный тип вики страницы')


class WikiIntegrationError(IntegrationError):
    help = _('Ошибка интеграции с Вики.')


class WikiRetiableError(RetriableError, WikiIntegrationError):
    help = _('Перезапускаемая ошибка с Вики.')


class WikiSupertagError(WikiIntegrationError):
    help = WIKI_PAGE_DOESNT_EXISTS_MESSAGE

    def __init__(self, supertag, cause=None):
        self.help = self.help % supertag
        super(WikiSupertagError, self).__init__(cause)


class WikiContentTypeError(WikiIntegrationError):
    help = WIKI_CONTENT_TYPE_ERROR


class WikiPermissionError(PermissionError, WikiIntegrationError):
    help = WIKI_NO_PERMISSION_MESSAGE

    def __init__(self, username, cause=None):
        self.help = self.help % username
        super(WikiPermissionError, self).__init__(cause)
