# -*- coding: utf-8 -*-
import factory

from bson import ObjectId
from events.accounts.factories import UserFactory
from events.conditions.factories import ContentTypeAttributeFactory
from events.surveyme.factories import (
    SurveyFactory,
    ProfileSurveyAnswerFactory,
)
from events.surveyme_integration.models import (
    ServiceSurveyHookSubscription,
    SurveyHook,
    SurveyHookCondition,
    SurveyHookTrigger,
    SubscriptionHeader,
    JSONRPCSubscriptionData,
    JSONRPCSubscriptionParam,
    StartrekSubscriptionData,
    SurveyHookConditionNode,
    SubscriptionAttachment,
    WikiSubscriptionData,
    IntegrationFileTemplate,
    HookSubscriptionNotification,
    SurveyVariable,
)


class SurveyHookFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyHook

    survey = factory.SubFactory(SurveyFactory)

    @factory.post_generation
    def triggers(self, create, extracted, **kwargs):
        if not create:
            # Simple build
            return

        if extracted:
            # A list of groups were passed in, use them
            for trigger in extracted:
                self.triggers.add(trigger)
        else:
            for trigger in SurveyHookTrigger.objects.all():
                self.triggers.add(trigger)


class SurveyHookConditionNodeFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyHookConditionNode

    hook = factory.SubFactory(SurveyHookFactory)


class SurveyHookConditionFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyHookCondition

    condition = 'eq'
    condition_node = factory.SubFactory(SurveyHookConditionNodeFactory)
    content_type_attribute = factory.SubFactory(ContentTypeAttributeFactory)


class ServiceSurveyHookSubscriptionFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = ServiceSurveyHookSubscription

    survey_hook = factory.SubFactory(SurveyHookFactory)
    service_type_action_id = 3


class SurveyVariableFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SurveyVariable

    variable_id = factory.LazyFunction(ObjectId)
    arguments = {}


class SubscriptionAttachmentFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SubscriptionAttachment

    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)


class SubscriptionHeaderFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = SubscriptionHeader

    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)


class HookSubscriptionNotificationFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = HookSubscriptionNotification

    survey = factory.SubFactory(SurveyFactory)
    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)
    answer = factory.SubFactory(ProfileSurveyAnswerFactory)
    user = factory.SubFactory(UserFactory)


class JSONRPCSubscriptionDataFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = JSONRPCSubscriptionData

    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)


class JSONRPCSubscriptionParamFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = JSONRPCSubscriptionParam

    subscription = factory.SubFactory(JSONRPCSubscriptionDataFactory)


class StartrekSubscriptionDataFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = StartrekSubscriptionData

    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)


class WikiSubscriptionDataFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = WikiSubscriptionData

    subscription = factory.SubFactory(ServiceSurveyHookSubscriptionFactory)


class IntegrationFileTemplateFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = IntegrationFileTemplate

    survey = factory.SubFactory(SurveyFactory)
