# -*- coding: utf-8 -*-
from django.db import models
from django.db.models.query import QuerySet


class HookSubscriptionNotificationQuerySet(QuerySet):
    def filter_notifications(self):
        return (
            self.filter(
                subscription__follow_result=True,
            )
            .select_related(
                'subscription__service_type_action__service_type',
                'survey__org',
            )
            .values(
                'subscription_id',
                'status',
                'context',
                'response',
                'error',
                'subscription__service_type_action__service_type__slug',
                'survey__org__dir_id',
            )
        )


class HookSubscriptionNotificationManager(models.Manager):
    def get_queryset(self):
        return HookSubscriptionNotificationQuerySet(self.model, using=self._db)
