# Generated by Django 2.2.17 on 2020-12-17 06:26

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from django.utils.timezone import utc
from events.common_app.fields import (
    JSONFieldForSimpleText,
    JSONFieldForTinyText,
)
from events.common_storages.proxy_storages import ProxyStorage
from events.surveyme_integration.models import (
    ObjectWithVariableMixin,
    SurveyHookConditionSourceFromRequestMixin,
    ProxyStorageFileField,
)


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('surveyme', '0001_initial'),
        ('conditions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='IntegrationFileTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255)),
                ('template', models.TextField(blank=True)),
                ('type', models.CharField(choices=[('pdf', 'pdf'), ('txt', 'txt')], default='pdf', max_length=255)),
                ('slug', models.SlugField(blank=True, null=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='integration_file_templates', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('survey', 'slug')},
            },
            bases=(ObjectWithVariableMixin, models.Model),
        ),
        migrations.CreateModel(
            name='IntegrationNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='JSONRPCSubscriptionData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceSurveyHookSubscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='date_of_change')),
                ('is_synchronous', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('context_language', models.CharField(default='ru', max_length=12)),
                ('follow_result', models.BooleanField(default=False)),
                ('title', models.CharField(blank=True, max_length=255)),
                ('body', models.TextField(blank=True)),
                ('email', models.CharField(blank=True, max_length=255)),
                ('phone', models.CharField(blank=True, max_length=255)),
                ('is_all_questions', models.BooleanField(default=True)),
                ('email_to_address', models.CharField(blank=True, max_length=255)),
                ('email_from_address', models.CharField(blank=True, max_length=255)),
                ('email_from_title', models.CharField(blank=True, max_length=255)),
                ('email_spam_check', models.BooleanField(default=False)),
                ('http_url', models.CharField(blank=True, max_length=255)),
                ('http_method', models.CharField(blank=True, choices=[('get', 'GET'), ('post', 'POST'), ('put', 'PUT'), ('delete', 'DELETE'), ('patch', 'PATCH')], default='get', max_length=10, null=True)),  # noqa
                ('http_format_name', models.CharField(blank=True, choices=[('json', 'json'), ('xml', 'xml')], default='json', max_length=10, null=True)),
                ('tvm2_client_id', models.CharField(blank=True, max_length=25, null=True)),
                ('attachment_templates', models.ManyToManyField(blank=True, related_name='subscriptions', to='surveyme_integration.IntegrationFileTemplate')),
                ('questions', models.ManyToManyField(blank=True, to='surveyme.SurveyQuestion')),
            ],
            options={
                'ordering': ('id',),
            },
            bases=(ObjectWithVariableMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ServiceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='SurveyHook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('is_active', models.BooleanField(default=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hooks', to='surveyme.Survey')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='SurveyHookTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='WikiSubscriptionData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('supertag', models.CharField(blank=True, max_length=255)),
                ('text', models.TextField(blank=True)),
                ('subscription', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='wiki', to='surveyme_integration.ServiceSurveyHookSubscription')),
            ],
        ),
        migrations.CreateModel(
            name='SurveyVariable',
            fields=[
                ('variable_id', models.CharField(max_length=32, primary_key=True, serialize=False)),
                ('var', models.CharField(max_length=50)),
                ('format_name', models.CharField(blank=True, max_length=50, null=True)),
                ('arguments', JSONFieldForSimpleText(null=True)),
                ('filters', JSONFieldForSimpleText(null=True)),
                ('hook_subscription', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme_integration.ServiceSurveyHookSubscription')),
                ('integration_file_template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme_integration.IntegrationFileTemplate')),
            ],
        ),
        migrations.CreateModel(
            name='SurveyHookConditionNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('hook', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='condition_nodes', to='surveyme_integration.SurveyHook')),
            ],
            options={
                'ordering': ('position',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SurveyHookCondition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('and', 'и'), ('or', 'или')], default='and', max_length=100)),
                ('condition', models.CharField(choices=[('eq', 'равно'), ('neq', 'не равно'), ('lt', 'меньше'), ('gt', 'больше')], default='eq', max_length=100)),
                ('value', models.CharField(blank=True, max_length=100)),
                ('position', models.PositiveSmallIntegerField(default=1)),
                ('condition_node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='surveyme_integration.SurveyHookConditionNode')),
                ('content_type_attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='conditions.ContentTypeAttribute')),
                ('node', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='items', to='surveyme_integration.SurveyHook')),
                ('survey_question', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='surveyme.SurveyQuestion')),
            ],
            options={
                'ordering': ('position',),
            },
            bases=(SurveyHookConditionSourceFromRequestMixin, models.Model),
        ),
        migrations.AddField(
            model_name='surveyhook',
            name='triggers',
            field=models.ManyToManyField(to='surveyme_integration.SurveyHookTrigger'),
        ),
        migrations.CreateModel(
            name='SubscriptionHeader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('value', models.CharField(max_length=255)),
                ('add_only_with_value', models.BooleanField(default=False, verbose_name='Добавлять только при заполненном значении')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='headers', to='surveyme_integration.ServiceSurveyHookSubscription')),
            ],
            options={
                'ordering': ['pk'],
            },
        ),
        migrations.CreateModel(
            name='SubscriptionAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', ProxyStorageFileField(storage=ProxyStorage(), upload_to='')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='surveyme_integration.ServiceSurveyHookSubscription')),
            ],
        ),
        migrations.CreateModel(
            name='StartrekSubscriptionData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('queue', models.CharField(blank=True, max_length=255)),
                ('parent', models.CharField(blank=True, max_length=255)),
                ('author', models.CharField(blank=True, max_length=255)),
                ('assignee', models.CharField(blank=True, max_length=255)),
                ('followers', JSONFieldForTinyText(blank=True, null=True)),
                ('tags', JSONFieldForTinyText(blank=True, null=True)),
                ('type', models.PositiveIntegerField(blank=True, null=True)),
                ('components', JSONFieldForTinyText(blank=True, null=True)),
                ('project', models.PositiveIntegerField(blank=True, null=True)),
                ('priority', models.PositiveIntegerField(blank=True, null=True)),
                ('subscription', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='startrek', to='surveyme_integration.ServiceSurveyHookSubscription')),
            ],
        ),
        migrations.CreateModel(
            name='ServiceTypeAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('slug', models.SlugField()),
                ('service_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme_integration.ServiceType')),
            ],
            options={
                'unique_together': {('service_type', 'slug')},
            },
        ),
        migrations.AddField(
            model_name='servicesurveyhooksubscription',
            name='service_type_action',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme_integration.ServiceTypeAction'),
        ),
        migrations.AddField(
            model_name='servicesurveyhooksubscription',
            name='survey_hook',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='surveyme_integration.SurveyHook'),
        ),
        migrations.CreateModel(
            name='JSONRPCSubscriptionParam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('value', models.CharField(max_length=255)),
                ('add_only_with_value', models.BooleanField(default=False, verbose_name='Добавлять только при заполненном значении')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='params', to='surveyme_integration.JSONRPCSubscriptionData')),
            ],
            options={
                'ordering': ['pk'],
            },
        ),
        migrations.AddField(
            model_name='jsonrpcsubscriptiondata',
            name='subscription',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='json_rpc', to='surveyme_integration.ServiceSurveyHookSubscription'),
        ),
        migrations.CreateModel(
            name='HookSubscriptionNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('notification_id', models.CharField(blank=True, max_length=32, null=True)),
                ('status', models.CharField(choices=[('pending', 'pending'), ('success', 'success'), ('error', 'error'), ('canceled', 'canceled')], default='pending', max_length=32)),  # noqa
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True, null=True)),
                ('date_finished', models.DateTimeField(null=True)),
                ('date_next_processing', models.DateTimeField(null=True)),
                ('date_retry', models.DateTimeField(null=True)),
                ('retries', models.IntegerField(null=True)),
                ('max_retries', models.IntegerField(null=True)),
                ('trigger_slug', models.CharField(max_length=50)),
                ('trigger_data', JSONFieldForSimpleText(null=True)),
                ('response', JSONFieldForSimpleText(null=True)),
                ('context', JSONFieldForSimpleText(null=True)),
                ('error', JSONFieldForSimpleText(null=True)),
                ('is_visible', models.BooleanField(db_index=True, default=True)),
                ('celery_task_id', models.CharField(blank=True, max_length=50, null=True)),
                ('answer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.ProfileSurveyAnswer')),
                ('subscription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='surveyme_integration.ServiceSurveyHookSubscription')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.Survey')),
                ('survey_group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='surveyme.SurveyGroup')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='HookSubscriptionNotificationCounter',
            fields=[
                ('subscription', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='surveyme_integration.ServiceSurveyHookSubscription')),
                ('errors_count', models.PositiveIntegerField(default=0)),
                ('date_updated', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0, tzinfo=utc))),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveyme.Survey')),
            ],
        ),
    ]
