# -*- coding: utf-8 -*-
from rest_framework import serializers

from events.common_app.serializers import IdentifierField
from events.common_app.utils import get_user_ip_address
from events.surveyme_integration.services.base.context_processors.fields import SafeCharField


class ContextProcessingError(Exception):
    pass


class ServiceContextInstance(object):
    def __init__(self, subscription, answer, trigger_data, notification_unique_id, force_render=False):
        self.subscription = subscription
        self.answer = answer
        self.trigger_data = trigger_data
        self.notification_unique_id = notification_unique_id
        self.force_render = force_render


class ContextProcessorBase(serializers.Serializer):
    notification_unique_id = serializers.CharField()
    survey_id = IdentifierField(source='answer.survey_id')
    answer_id = serializers.IntegerField(source='answer.id')
    subscription_id = serializers.IntegerField(source='subscription.id')
    force_render = serializers.BooleanField(default=False)
    org_dir_id = SafeCharField(source='answer.survey.org.dir_id', default=None)
    ip = SafeCharField(source='answer.source_request.ip', default=get_user_ip_address)
    url = SafeCharField(source='answer.source_request.url', default='')
    request_id = SafeCharField(source='answer.source_request.request_id', default='')

    class Meta:
        fields = [
            'notification_unique_id',
            'survey_id',
            'answer_id',
            'subscription_id',
            'force_render',
            'org_dir_id',
            'ip',
            'url',
            'request_id',
        ]
