# -*- coding: utf-8 -*-
from events.surveyme_integration.services.base.context_processors.base import ServiceContextInstance, \
    ContextProcessingError
from events.surveyme_integration.exceptions import RetriableError


class ServiceBase(object):
    # todo: test ContextProcessingError
    # todo: test TemplateSyntaxError
    retriable_exceptions = (
        ContextProcessingError,
        RetriableError,
    )
    default_action_processor_class = None
    default_context_processor_class = None

    def get_action_processor(self, data, status):
        kwargs = {
            'data': data,
            'status': status
        }
        return self.get_action_processor_class(**kwargs)(**kwargs)

    def get_action_processor_class(self, data, status):
        return self.default_action_processor_class

    def get_context_processor(self, subscription, answer, trigger_data, notification_unique_id, force_render):
        service_context_instance = ServiceContextInstance(
            subscription=subscription,
            answer=answer,
            trigger_data=trigger_data,
            notification_unique_id=notification_unique_id,
            force_render=force_render,
        )
        return self.get_context_processor_class(service_context_instance)(service_context_instance)

    def get_context_processor_class(self, service_context_instance):
        return self.default_context_processor_class

    def get_response_data_from_exception(self, exc):
        return None
