# -*- coding: utf-8 -*-
from smtplib import SMTPException

from events.surveyme_integration.services.base.services import ServiceBase
from events.surveyme_integration.services.email.action_processors import EmailActionProcessor
from events.surveyme_integration.services.email.context_processors import EmailContextProcessor


class EmailService(ServiceBase):
    retriable_exceptions = ServiceBase.retriable_exceptions + (
        SMTPException,
    )  # todo test me
    default_context_processor_class = EmailContextProcessor
    default_action_processor_class = EmailActionProcessor

    def send(self, data, status):
        action_processor = self.get_action_processor(data, status)
        return action_processor.do_action()
