# -*- coding: utf-8 -*-
import base64

from django.utils.encoding import force_str


class HTTPAttachmentsMetaInfoCalculatorMixin(object):
    def get_attachment_item(self, path, data_source):
        item = super(HTTPAttachmentsMetaInfoCalculatorMixin, self).get_attachment_item(path, data_source)
        meta_info_header = self.get_meta_info_header(item, data_source)
        item['headers'] = {
            'X-META-INFO': meta_info_header,
            'X-META-INFO-BASE64': force_str(base64.b64encode(meta_info_header.encode('utf-8'))),
        }
        return item

    def get_meta_info_header(self, attachment_item, data_source):
        return force_str(
            self.context_processor._render_data_for_format(
                data=self.get_meta_info(attachment=attachment_item, data_source=data_source),
                format_name=self.context_processor.get_format_name()
            )
        )

    def get_meta_info(self, attachment, data_source):
        return {
            'frontend_url': attachment.get('frontend_url')
        }


class HTTPAttachmentsCalculator(HTTPAttachmentsMetaInfoCalculatorMixin):
    def get_meta_info(self, attachment, data_source):
        response = super(HTTPAttachmentsCalculator, self).get_meta_info(attachment=attachment, data_source=data_source)
        response['question'] = attachment.get('question')
        return response


class HTTPStrictInterfaceAttachmentsCalculator(HTTPAttachmentsMetaInfoCalculatorMixin):
    def get_meta_info(self, attachment, data_source):
        response = super(HTTPStrictInterfaceAttachmentsCalculator, self).get_meta_info(
            attachment=attachment,
            data_source=data_source
        )
        response[self.context_processor.service_field_name] = self.context_processor.service_field_ids[
            data_source['field_name']
        ]
        return response

    def get_attachments_source(self):
        return [
            {
                'question': self.context_processor.get_subscription_field_value(file_field_name),
                'field_name': file_field_name
            }
            for file_field_name in
            self.context_processor.file_fields
        ]

    def get_question_from_data_source(self, data_source):
        return data_source['question']
