# -*- coding: utf-8 -*-
from events.surveyme.answer_value import get_value_for_question


class HTTPBodyDataBaseCalculator:
    def calculate(self):
        body_data = {}
        for i, data_source in enumerate(self.get_body_data_source(), start=1):
            body_data['field_%s' % i] = self.get_body_data_item(data_source=data_source)
        return body_data

    def get_body_data_source(self):
        raise NotImplementedError()

    def get_body_data_item(self, data_source):
        return {
            'value': self.get_body_data_item_value_from_data_source(data_source),
        }

    def get_body_data_item_value_from_data_source(self, data_source):
        raise NotImplementedError()


class HTTPBodyDataCalculator(HTTPBodyDataBaseCalculator):
    def get_body_data_item(self, data_source):
        item = super(HTTPBodyDataCalculator, self).get_body_data_item(data_source)
        question = data_source
        item['question'] = {
            'id': question.id,
            'label': {
                'ru': question.label
            }
        }
        return item

    def get_body_data_source(self):
        return self.context_processor.get_text_questions()

    def get_body_data_item_value_from_data_source(self, data_source):
        answer = self.context_processor.answer
        question = data_source
        return get_value_for_question(answer, question.pk)


class HTTPStrictInterfaceBodyDataCalculator(HTTPBodyDataBaseCalculator):
    def get_body_data_source(self):
        return [
            {
                'value': self.context_processor.render_variables(
                    self.context_processor.get_subscription_field_value(text_field_name)
                ),
                'field_name': text_field_name
            }
            for text_field_name in
            self.context_processor.text_fields
        ]

    def get_body_data_item_value_from_data_source(self, data_source):
        return data_source['value']

    def get_body_data_item(self, data_source):
        item = super(HTTPStrictInterfaceBodyDataCalculator, self).get_body_data_item(data_source)
        item[self.context_processor.service_field_name] = self.context_processor.service_field_ids[data_source['field_name']]
        return item
