# -*- coding: utf-8 -*-
from events.surveyme_integration.services.http.context_processors.body_data_calculators import (
    HTTPStrictInterfaceBodyDataCalculator,
)
from events.surveyme_integration.services.http.context_processors.attachments_calculators import (
    HTTPStrictInterfaceAttachmentsCalculator
)
from events.surveyme_integration.services.base.context_processors.base import ContextProcessorBase


class HTTPStrictInterfaceContextProcessor(ContextProcessorBase):
    subscription_attr = None
    service_field_ids = {}
    service_field_name = None
    file_fields = []
    render_fields = []
    body_data_calculator_class = HTTPStrictInterfaceBodyDataCalculator
    attachments_calculator_class = HTTPStrictInterfaceAttachmentsCalculator

    def get_subscription_field_value(self, field_name):
        from events.surveyme_integration.models import ServiceSurveyHookSubscription

        related_model = ServiceSurveyHookSubscription._meta.get_field(self.subscription_attr).model
        try:
            obj = getattr(self.subscription, self.subscription_attr)
        except related_model.DoesNotExist:
            return None
        else:
            return getattr(obj, field_name)
