# -*- coding: utf-8 -*-
from events.surveyme_integration.services.base.services import ServiceBase
from events.surveyme_integration.services.http.action_processors import (
    PostHTTPActionProcessor,
    PutHTTPActionProcessor,
    ArbitraryHTTPActionProcessor,
    parse_response,
)
from events.surveyme_integration.services.http.context_processors import (
    HTTPContextProcessor,
    ArbitraryHTTPContextProcessor,
)


class HTTPService(ServiceBase):
    default_context_processor_class = HTTPContextProcessor
    default_action_processor_class = PostHTTPActionProcessor

    def put(self, data, status):
        self.default_action_processor_class = PutHTTPActionProcessor
        return self.do_action(data, status)

    def arbitrary(self, data, status):
        self.default_action_processor_class = ArbitraryHTTPActionProcessor
        return self.do_action(data, status)

    def get_context_processor_class(self, service_context_instance):
        if service_context_instance.subscription.service_type_action.slug == 'arbitrary':
            return ArbitraryHTTPContextProcessor
        return self.default_context_processor_class

    def post(self, data, status):
        return self.do_action(data, status)

    def do_action(self, data, status):
        action_processor = self.get_action_processor(data, status)
        return action_processor.do_action()

    def get_response_data_from_exception(self, exc):
        # todo: test me
        if hasattr(exc, 'response') and exc.response is not None:
            return parse_response(exc.response)
