# -*- coding: utf-8 -*-
from events.surveyme_integration.services.base.services import ServiceBase
from events.surveyme_integration.services.startrek.action_processors import (
    StartrekCreateTicketActionProcessor,
    StartrekUpdateOrCreateTicketActionProcessor
)
from events.surveyme_integration.services.startrek.context_processors import StartrekContextProcessor


class StartrekService(ServiceBase):
    default_context_processor_class = StartrekContextProcessor

    def create_ticket(self, data, status):
        return StartrekCreateTicketActionProcessor(data, status).do_action()

    def update_or_create_ticket(self, data, status):
        return StartrekUpdateOrCreateTicketActionProcessor(data, status).do_action()
