# coding: utf-8


from rest_framework import serializers
from events.surveyme_integration.services.base.context_processors.base import ContextProcessorBase
from events.surveyme_integration.services.base.context_processors.fields import (
    RenderedCharField,
)


class WikiContextProcessor(ContextProcessorBase):
    supertag = serializers.CharField(source='subscription.wiki.supertag')
    text = RenderedCharField(source='subscription.wiki.text')

    class Meta(ContextProcessorBase.Meta):
        fields = ContextProcessorBase.Meta.fields + [
            'supertag',
            'text',
        ]
