# -*- coding: utf-8 -*-
from events.surveyme_integration.services.base.services import ServiceBase
from events.surveyme_integration.services.http.action_processors import parse_response
from events.surveyme_integration.services.wiki.action_processors import WikiActionProcessor
from events.surveyme_integration.services.wiki.context_processors import WikiContextProcessor


class WikiService(ServiceBase):
    default_context_processor_class = WikiContextProcessor

    def append_to_wiki_page(self, data, status):
        return WikiActionProcessor(data, status).do_action()

    def get_response_data_from_exception(self, exc):
        if hasattr(exc, 'response') and exc.response is not None:
            return parse_response(exc.response)
