# -*- coding: utf-8 -*-

from django.db.utils import IntegrityError


def set_integration_file_template_slug(sender, instance, created, **kwargs):
    if instance.slug in ['', None]:
        set_unique_integration_file_template_slug(instance)


def set_unique_integration_file_template_slug(template, next_counter=0):
    from events.surveyme_integration.models import IntegrationFileTemplate

    template.slug = template.generate_next_slug(next_counter=next_counter)
    try:
        IntegrationFileTemplate.objects.filter(pk=template.pk).update(slug=template.slug)
    except IntegrityError:
        set_unique_integration_file_template_slug(template, next_counter=next_counter+1)


def create_hook_subscription_notification_counter(sender, instance, created, **kwargs):
    from events.surveyme_integration.models import HookSubscriptionNotificationCounter
    if created:
        HookSubscriptionNotificationCounter.objects.create(
            subscription=instance,
            survey=instance.survey_hook.survey,
        )
