# -*- coding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _


class BaseStatus(object):
    name = None
    title = None
    could_be_canceled = False
    could_be_processed = False
    could_be_restarted = False


class PendingStatus(BaseStatus):
    name = 'pending'
    title = _('В ожидании')
    could_be_canceled = True
    could_be_processed = True


class ErrorStatus(BaseStatus):
    name = 'error'
    title = _('Ошибка')
    could_be_restarted = True


class SuccessStatus(BaseStatus):
    name = 'success'
    title = _('Успешно')


class CanceledStatus(BaseStatus):
    name = 'canceled'
    title = _('Отменено')
    could_be_restarted = True


statuses_list = [
    PendingStatus,
    ErrorStatus,
    SuccessStatus,
    CanceledStatus
]
statuses_by_name = dict([(i.name, i) for i in statuses_list])
statuses_could_be_canceled = [i for i in statuses_list if i.could_be_canceled]
statuses_could_be_restarted = [i for i in statuses_list if i.could_be_restarted]
