# -*- coding: utf-8 -*-
from collections import defaultdict, OrderedDict
from django.conf import settings
from enum import Enum

from events.surveyme_integration.variables.browser import (
    BrowserDataVariable,
    BrowserOSFamilyVariable,
    BrowserOSNameVariable,
    BrowserOSVersionVariable,
    BrowserNameVariable,
    BrowserVersionVariable,
    BrowserEngineVariable,
)
from events.surveyme_integration.variables.form import (
    FormAnswerIdVariable,
    FormNameVariable,
    FormQuestionAnswerVariable,
    FormQuestionsAnswersVariable,
    FormIdVariable,
    FormQuestionAnswerChoiceSlugVariable,
    FormQuestionAnswerWithPrefixVariable,
    FormDateVariable,
    FormValidationVariable,
    FormAuthorEmailVariable,
)
from events.surveyme_integration.variables.order import OrderKeysFromBundleVariable
from events.surveyme_integration.variables.request import (
    RequestIpVariable,
    RequestHostVariable,
    RequestURLVariable,
    RequestHeadersVariable,
    RequestHeaderVariable,
    RequestQueryParamsVariable,
    RequestQueryParamVariable,
    RequestCookiesVariable,
    RequestCookieVariable,
)
from events.surveyme_integration.variables.session import (
    SessionRefererVariable,
)
from events.surveyme_integration.variables.user import (
    UserNameVariable,
    UserLoginVariable,
    UserLoginB2BVariable,
    UserUIDVariable,
    UserEmailVariable,
    UserKarmaVariable,
    UserGenderVariable,
    UserDepartmentNameVariable,
    UserPhoneVariable,
    UserHeadVariable,
    UserGroupsVariable,
    UserPublicIdVariable,
)

from events.surveyme_integration.variables.disk import (
    DiskIsPaidVariable,
    DiskIsPaidPsBillingVariable,
    DiskCarmaVariable,
)

from events.surveyme_integration.variables.kinopoisk import (
    KinopoiskEmailVariable,
    KinopoiskMigrationStatusVariable,
    KinopoiskUserIdVariable,
    KinopoiskIsBetaUserVariable,
)

from events.surveyme_integration.variables.geobase import (
    GeobaseIdVariable,
    GeobaseNameVariable,
)

from events.surveyme_integration.variables.music import (
    MusicStatusVariable,
)

from events.surveyme_integration.variables.directory import (
    DirectoryIsAdminVariable,
    DirectoryIsUserVariable,
    DirectoryOrgIdVariable,
    DirectorySubscriptionPlanVariable,
    DirectoryVIPVariable,
    DirectoryStaffMetaUserVariable,
    DirectoryStaffMetaQuestionVariable,
)

from events.surveyme_integration.variables.staff import (
    StaffMetaUserVariable,
    StaffMetaQuestionVariable,
    StaffExternalLoginVariable,
    StaffExternalLoginFromRequestVariable,
)

from events.surveyme_integration.variables.quiz import (
    QuizTotalScores,
    QuizQuestionCount,
    QuizAnswerScores,
    QuizResultTitle,
    QuizResultDescription,
    QuizQuestionScores,
)


if settings.APP_TYPE == 'forms_biz':
    variables_list = [
        RequestHostVariable,
        RequestURLVariable,
        RequestQueryParamVariable,
        RequestQueryParamsVariable,

        BrowserNameVariable,
        BrowserVersionVariable,
        BrowserOSFamilyVariable,
        BrowserOSNameVariable,
        BrowserOSVersionVariable,

        FormIdVariable,
        FormNameVariable,
        FormQuestionAnswerVariable,
        FormQuestionsAnswersVariable,
        FormAnswerIdVariable,
        FormDateVariable,
        FormQuestionAnswerChoiceSlugVariable,
        FormAuthorEmailVariable,

        UserNameVariable,
        UserLoginB2BVariable,
        UserEmailVariable,
        UserGenderVariable,
        UserDepartmentNameVariable,
        UserPhoneVariable,
        UserHeadVariable,
        UserGroupsVariable,

        DirectoryStaffMetaUserVariable,
        DirectoryStaffMetaQuestionVariable,

        QuizTotalScores,
        QuizQuestionCount,
        QuizAnswerScores,
        QuizResultTitle,
        QuizResultDescription,
        QuizQuestionScores,
    ]
elif settings.APP_TYPE == 'forms_int':
    variables_list = [
        RequestIpVariable,
        RequestHostVariable,
        RequestURLVariable,
        RequestHeadersVariable,
        RequestHeaderVariable,
        RequestQueryParamsVariable,
        RequestQueryParamVariable,
        RequestCookiesVariable,
        RequestCookieVariable,

        BrowserDataVariable,
        BrowserOSFamilyVariable,
        BrowserOSNameVariable,
        BrowserOSVersionVariable,
        BrowserNameVariable,
        BrowserVersionVariable,
        BrowserEngineVariable,

        SessionRefererVariable,

        FormIdVariable,
        FormNameVariable,
        FormQuestionAnswerVariable,
        FormQuestionsAnswersVariable,
        FormAnswerIdVariable,
        FormDateVariable,
        FormQuestionAnswerChoiceSlugVariable,
        FormValidationVariable,
        FormAuthorEmailVariable,

        UserNameVariable,
        UserLoginVariable,
        UserUIDVariable,
        UserEmailVariable,

        GeobaseIdVariable,
        GeobaseNameVariable,

        StaffMetaUserVariable,
        StaffMetaQuestionVariable,

        QuizTotalScores,
        QuizQuestionCount,
        QuizAnswerScores,
        QuizResultTitle,
        QuizResultDescription,
        QuizQuestionScores,
    ]

else:  # forms_ext, forms_ext_admin
    variables_list = [
        UserNameVariable,
        UserLoginVariable,
        UserUIDVariable,
        UserEmailVariable,
        UserKarmaVariable,
        UserPublicIdVariable,

        FormIdVariable,
        FormNameVariable,
        FormQuestionAnswerVariable,
        FormQuestionsAnswersVariable,
        FormAnswerIdVariable,
        FormDateVariable,
        FormQuestionAnswerChoiceSlugVariable,
        FormValidationVariable,
        FormAuthorEmailVariable,

        BrowserDataVariable,
        BrowserOSFamilyVariable,
        BrowserOSNameVariable,
        BrowserOSVersionVariable,
        BrowserNameVariable,
        BrowserVersionVariable,
        BrowserEngineVariable,

        RequestIpVariable,
        RequestHostVariable,
        RequestURLVariable,
        RequestHeadersVariable,
        RequestHeaderVariable,
        RequestQueryParamsVariable,
        RequestQueryParamVariable,
        RequestCookiesVariable,
        RequestCookieVariable,

        SessionRefererVariable,

        GeobaseIdVariable,
        GeobaseNameVariable,

        DirectoryIsAdminVariable,
        DirectoryIsUserVariable,
        DirectoryOrgIdVariable,
        DirectorySubscriptionPlanVariable,
        DirectoryVIPVariable,

        DiskIsPaidVariable,
        DiskIsPaidPsBillingVariable,
        DiskCarmaVariable,

        KinopoiskEmailVariable,
        KinopoiskMigrationStatusVariable,
        KinopoiskUserIdVariable,
        KinopoiskIsBetaUserVariable,

        MusicStatusVariable,

        FormQuestionAnswerWithPrefixVariable,

        OrderKeysFromBundleVariable,

        StaffExternalLoginVariable,
        StaffExternalLoginFromRequestVariable,

        QuizTotalScores,
        QuizQuestionCount,
        QuizAnswerScores,
        QuizResultTitle,
        QuizResultDescription,
        QuizQuestionScores,
    ]

variables_list = sorted(variables_list, key=lambda x: (x.category.order, x.name))
variables_by_name = OrderedDict([(i.name, i) for i in variables_list])
bulk_variable_groups = {'staff', }

variable_categories_list = sorted(set(
    var.category.__class__
    for var in variables_list
), key=lambda x: x.order)
variable_categories_by_name = OrderedDict([(i.name, i) for i in variable_categories_list])

renderers_list = [it for var in variables_list for it in var.renderer_classes]
renderers_by_name = {it.format_name: it for it in renderers_list}


class _StrEnum(str, Enum):
    pass


VariableTypes = _StrEnum('VariableTypes', {name: name for name in variables_by_name})
VariableCategoryTypes = _StrEnum('VariableCategoryTypes', {name: name for name in variable_categories_by_name})
RendererTypes = _StrEnum('RendererTypes', {name: name for name in renderers_by_name})


def _get_render_to_variable():
    result = defaultdict(list)
    for var in variables_list:
        for renderer in var.renderer_classes:
            result[renderer.format_name].append(var.name)
    return result


renderer_to_variable = _get_render_to_variable()
