# -*- coding: utf-8 -*-


class BulkVariableRequester(object):
    def __init__(self, group_data, answer):
        self.group_data = group_data
        self.answer = answer

    def get_response(self):
        raise NotImplementedError()

    def get_user(self):
        return self.answer.user


class BaseVariableCategory(object):
    name = None
    title = None
    order = 999


class BaseRenderer(object):
    format_name = None
    format_title = None

    def render(self, data):
        raise NotImplementedError


class BaseVariable(object):
    name = None
    title = None
    category = None
    arguments = None
    connect_only = False
    renderer_classes = []
    filters = {}

    def __init__(self, answer, trigger_data=None, notification_id=None, variable_data=None, **kwargs):
        self.answer = answer
        self.trigger_data = trigger_data or {}
        self.notification_id = notification_id
        self.variable_data = variable_data or {}

    def get_value(self, format_name=None):
        raise NotImplementedError()

    def get_renderer_class(self, format_name):
        # todo: test me
        for rederer_class in self.renderer_classes:
            if rederer_class.format_name == format_name:
                return rederer_class
