# -*- coding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _

from events.common_app.utils import browser_detector
from events.surveyme_integration.variables.base import BaseVariableCategory, BaseVariable


class BrowserVariableCategory(BaseVariableCategory):
    name = 'browser'
    title = _('Браузер')
    order = 6


class BrowserBaseVariable(BaseVariable):
    category = BrowserVariableCategory()

    def get_browser_data(self):
        if self.answer.source_request:
            user_agent = self.answer.source_request.get('headers').get('user-agent')
            if user_agent:
                return browser_detector.detect(user_agent)


class BrowserSingleValueBaseVariable(BrowserBaseVariable):
    data_key = None

    def get_value(self, format_name=None):
        return (self.get_browser_data() or {}).get(self.data_key)


class BrowserDataVariable(BrowserBaseVariable):
    name = 'browser.all_data'
    title = _('Все данные')

    def get_value(self, format_name=None):
        return self.get_browser_data()


class BrowserOSFamilyVariable(BrowserSingleValueBaseVariable):
    name = 'browser.osfamily'
    data_key = 'OSFamily'
    title = _('Семейство ОС')


class BrowserOSNameVariable(BrowserSingleValueBaseVariable):
    name = 'browser.osname'
    data_key = 'OSName'
    title = _('Название ОС')


class BrowserOSVersionVariable(BrowserSingleValueBaseVariable):
    name = 'browser.osversion'
    data_key = 'OSVersion'
    title = _('Версия ОС')


class BrowserNameVariable(BrowserSingleValueBaseVariable):
    name = 'browser.name'
    data_key = 'BrowserName'
    title = _('Название браузера')


class BrowserVersionVariable(BrowserSingleValueBaseVariable):
    name = 'browser.version'
    data_key = 'BrowserVersion'
    title = _('Версия браузера')


class BrowserEngineVariable(BrowserSingleValueBaseVariable):
    name = 'browser.engine'
    data_key = 'BrowserEngine'
    title = _('Движок')
